<?php get_header(); ?>
	<main class="main-container inner-page" aria-label="Content">
	    <style>
	        .everywhere {
                display: none;
            }
            
            .show-only-in-project-page {
                display: block!important;
            }
	    </style>
        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
        
        <?php if ( has_post_thumbnail() ) { ?>
        <div class="featured-container thumbnail-of-port-top has-white-color" style="background-image:url('<?php echo get_the_post_thumbnail_url( $post->ID, 'full' ); ?>')">
            <div class="page-title"><h2 class="wp-block-heading"><strong><a href="<?php echo get_home_url().'/projects';?>">PROJECTS</a>
            <?php
            $duration = get_post_meta(get_the_ID(),'project_duration',true);
            $gallery = get_post_meta(get_the_ID(),'project_gallery',true);
            $loc = get_the_terms(get_the_ID(),'project-location');
            $location = $loc[0]->name;
            $cat = get_the_terms(get_the_ID(),'project-category');
            $category = $cat[0]->name;
            $category_link = get_term_link($category,'project-category');
            if (!empty($category)) echo '<br>> <a class="uppercase" href="'.$category_link.'">'.$category.'</a>';
            ?>
            </strong></h2>
            <h1><?php echo str_replace('|','<br>',get_the_title());?></h1>
            </div>
        </div>
        <?php } ?>
        <div class="grid-container-full">
            <div class="grid-x main-row">
                <div class="small-12 medium-12 large-12 cell main-content">
                    <!-- section -->
                    <section>
						<!-- article -->
						<article id="post-<?php the_ID(); ?>" <?php post_class('project-article'); ?>>
							
							<div class="project-content the-content">
								<div class="wp-block-cover is-light has-black-color has-text-color has-link-color">
								    <div class="wp-block-cover__inner-container is-layout-constrained wp-block-cover-is-layout-constrained">
								        
								        <!--PROJECT INFO-->
                                        <div class="wp-block-columns is-layout-flex wp-block-columns-is-layout-flex project-info-top opposite-flex">
                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:25%">
                                                <h3 class="wp-block-heading"><strong>PROJECT<br>INFO</strong></h3>
                                            </div>
                                            <div class="wp-block-column inner-link is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:75%">
                                                <div class="wp-block-group">
                                                    <div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">
                                                        <div class="wp-block-columns is-layout-flex wp-block-columns-is-layout-flex">
                                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow the-project-content">
                                                                <?php the_content();?>
                                                            </div>
                                                            <?php if (!empty($category)) { ?>
                                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow project-info-type">
                                                                <p class="info-name"><?php echo __('Type', 'airtec-project');?></p>
                                                                <p class="info-value"><strong class="uppercase"><?php echo $category;?></strong></p>
                                                            </div>
                                                            <?php } ?>
                                                            <?php if (!empty($location)) { ?>
                                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow project-info-location">
                                                                <p class="info-name"><?php echo __('Location', 'airtec-project');?></p>
                                                                <p class="info-value"><strong><?php echo $location;?></strong></p>
                                                            </div>
                                                            <?php } ?>
                                                            <?php if (!empty($location)) { ?>
                                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow project-info-location">
                                                                <p class="info-name"><?php echo __('Project Duration', 'airtec-project');?></p>
                                                                <p class="info-value"><strong><?php echo $duration;?></strong></p>
                                                            </div>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
								        <!--END PROJECT INFO-->
                                        <?php if (!empty($gallery)) { ?>
								        <!--PROJECT GALLERY-->
								        <div class="wp-block-columns is-layout-flex wp-block-columns-is-layout-flex project-gallery opposite-flex">
                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:25%"></div>
                                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:75%">
                                                <?php echo do_shortcode($gallery);?>
                                            </div>
                                        </div>
                                        <!--END PROJECT GALLERY-->
								        <?php } ?>
								        
                                    </div>
                                </div>
								        <?php 
								        if ( ICL_LANGUAGE_CODE=='en' ) $pattern_id = 343; else $pattern_id = 63;
								        $query_pattern = get_post($pattern_id); 
                                        $content_pattern = apply_filters('the_content', $query_pattern->post_content);
                                        
                                        echo $content_pattern;
								        ?>
							</div>
						</article>
						<!-- /article -->
                    <?php endwhile; ?>
                    <?php else: ?>
                        <?php get_template_part('templates/content', 'none'); ?>
                    <?php endif; ?>
                    </section>
                    <!-- /section -->
                </div>
            </div>
        </div>
	</main>

<?php get_footer(); ?>