<?php
/**
 * WordPress Social Media widget
 * 
 * 
 */

class social_widget extends WP_Widget {
 
  public function __construct() {
      $widget_ops = array('classname' => 'social_widget', 'description' => 'Displays text with no widget wrapper!' );
      //$this->WP_Widget('social_widget', 'Social Widget', $widget_ops);
      parent::__construct('social_widget','Social Widget', $widget_ops);
  }
  
  function widget($args, $instance) {
    // PART 1: Extracting the arguments + getting the values
    extract($args, EXTR_SKIP);
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
  $fb = empty($instance['fb']) ? '' : $instance['fb'];
  $twitter = empty($instance['twitter']) ? '' : $instance['twitter'];
  $instagram = empty($instance['instagram']) ? '' : $instance['instagram'];
  $youtube = empty($instance['youtube']) ? '' : $instance['youtube'];
  $linkedin = empty($instance['linkedin']) ? '' : $instance['linkedin'];
    $text = empty($instance['text']) ? '' : $instance['text'];
   
    // Before widget code, if any
    echo (isset($before_widget)?$before_widget:'');
   
    // PART 2: The title and the text output
    if (!empty($title))
      echo $before_title . $title . $after_title;;
    if (!empty($text))
      echo $text;
  ?>
  <div class="social_icons"> 
  <?php 
  if (!empty($fb)){ ?>
    <a href="<?php echo $fb ?>"><?php echo do_shortcode('[icon_facebook]'); ?></a>
  <?php } ?><?php
  if (!empty($twitter)){ ?>
    <a href="<?php echo $twitter ?>"><?php echo do_shortcode('[icon_twitter]'); ?></a>
  <?php } ?><?php
  if (!empty($instagram)){ ?>
    <a href="<?php echo $instagram ?>"><?php echo do_shortcode('[icon_instagram]'); ?></a>
  <?php } ?><?php
  if (!empty($youtube)){ ?>
    <a href="<?php echo $youtube ?>"><?php echo do_shortcode('[icon_youtube]'); ?></a>
  <?php } ?><?php
  if (!empty($linkedin)){ ?>
    <a href="<?php echo $linkedin ?>"><?php echo do_shortcode('[icon_linkedin]'); ?></a>
  <?php } ?>  
    
  </div> <!-- /social_icons -->
  <?php
    // After widget code, if any  
    echo (isset($after_widget)?$after_widget:'');
  }
 
  public function form( $instance ) {
   
     // PART 1: Extract the data from the instance variable
     $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
     $title = $instance['title'];
     $text = $instance['text'];   
     $fb = $instance['fb'];
   $twitter = $instance['twitter']; 
   $instagram = $instance['instagram']; 
   $youtube = $instance['youtube']; 
   $linkedin = $instance['linkedin']; 
    
     // PART 2-3: Display the fields
     ?>

    <!-- Widget Facebook START -->
     <p>
      <label for="<?php echo $this->get_field_id('fb'); ?>">Facebook: 
        <input class="widefat" id="<?php echo $this->get_field_id('fb'); ?>" 
               name="<?php echo $this->get_field_name('fb'); ?>" type="text" 
               value="<?php echo attribute_escape($fb); ?>" />
      </label>
      </p>
      <!-- Widget Facebook END -->

  <!-- Widget twitter START -->
     <p>
      <label for="<?php echo $this->get_field_id('twitter'); ?>">Twitter: 
        <input class="widefat" id="<?php echo $this->get_field_id('twitter'); ?>" 
               name="<?php echo $this->get_field_name('twitter'); ?>" type="text" 
               value="<?php echo attribute_escape($twitter); ?>" />
      </label>
      </p>
      <!-- Widget twitter END -->

  <!-- Widget instagram START -->
     <p>
      <label for="<?php echo $this->get_field_id('instagram'); ?>">Instagram: 
        <input class="widefat" id="<?php echo $this->get_field_id('instagram'); ?>" 
               name="<?php echo $this->get_field_name('instagram'); ?>" type="text" 
               value="<?php echo attribute_escape($instagram); ?>" />
      </label>
      </p>
      <!-- Widget instagram END -->

    <!-- Widget youtube START -->
     <p>
      <label for="<?php echo $this->get_field_id('youtube'); ?>">Youtube: 
        <input class="widefat" id="<?php echo $this->get_field_id('youtube'); ?>" 
               name="<?php echo $this->get_field_name('youtube'); ?>" type="text" 
               value="<?php echo attribute_escape($youtube); ?>" />
      </label>
      </p>
      <!-- Widget youtube END -->

    <!-- Widget linkedin START -->
     <p>
      <label for="<?php echo $this->get_field_id('linkedin'); ?>">Linkedin: 
        <input class="widefat" id="<?php echo $this->get_field_id('linkedin'); ?>" 
               name="<?php echo $this->get_field_name('linkedin'); ?>" type="text" 
               value="<?php echo attribute_escape($linkedin); ?>" />
      </label>
      </p>
      <!-- Widget linkedin END -->
   
     <!-- PART 3: Widget Text field START -->
     <p>
      <label for="<?php echo $this->get_field_id('text'); ?>">Text: 
        <input class="widefat" id="<?php echo $this->get_field_id('text'); ?>" 
               name="<?php echo $this->get_field_name('text'); ?>" type="text" 
               value="<?php echo attribute_escape($text); ?>" />
        </label>
      </p>
      <!-- Widget Text field END -->
     <?php
   
  }
 
  function update($new_instance, $old_instance) {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['text'] = $new_instance['text'];
  $instance['fb'] = $new_instance['fb'];
  $instance['twitter'] = $new_instance['twitter'];
  $instance['instagram'] = $new_instance['instagram'];
  $instance['youtube'] = $new_instance['youtube'];
  $instance['linkedin'] = $new_instance['linkedin'];
    return $instance;
  }
  
}


//add_action( 'widgets_init', create_function('', 'return register_widget("social_widget");') );
add_action ( 'widgets_init', 'social_widget_register' );
function social_widget_register() {
    return register_widget('social_widget');
}
?>