<?php
/**
 * WordPress text widget with no wrapper
 * 
 * 
 */

class contact_info extends WP_Widget {
 
  public function __construct() {
      $widget_ops = array('classname' => 'contact_info', 'description' => 'Displays Contact Info!' );
      parent::__construct('contact_info','Contact Info from Theme Settings', $widget_ops);
  }
  
  function widget($args, $instance) {
    // PART 1: Extracting the arguments + getting the values
    extract($args, EXTR_SKIP);
    $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
  	$addresses = empty($instance['addresses']) ? '' : $instance['addresses'];
  	$phones = empty($instance['phones']) ? '' : $instance['phones'];
    $mobiles = empty($instance['mobiles']) ? '' : $instance['mobiles'];
    $emails = empty($instance['emails']) ? '' : $instance['emails'];
  	$social = empty($instance['social']) ? '' : $instance['social'];
  	$addresses_pos = empty($instance['addresses_pos']) ? '' : $instance['addresses_pos'];
  	$phones_pos = empty($instance['phones_pos']) ? '' : $instance['phones_pos'];
    $mobiles_pos = empty($instance['mobiles_pos']) ? '' : $instance['mobiles_pos'];
    $emails_pos = empty($instance['emails_pos']) ? '' : $instance['emails_pos'];
  	$social_pos = empty($instance['social_pos']) ? '' : $instance['social_pos'];
    $infos = array();
    $infos[$addresses_pos]['value'] = $addresses;
    $infos[$addresses_pos]['type'] = 'addresses';
    $infos[$phones_pos]['value'] = $phones;
    $infos[$phones_pos]['type'] = 'phones';
    $infos[$emails_pos]['value'] = $emails;
    $infos[$emails_pos]['type'] = 'emails';
    $infos[$social_pos]['value'] = $social;
    $infos[$social_pos]['type'] = 'social';
   
    // Before widget code, if any
    echo $before_widget;
   
    if (strlen($title)>2) {
      echo '<h3>' . $title . '</h3>';
    }
    // PART 2: The title and the text output
    ksort($infos);
	foreach ($infos as $pos=>$info) {
	    if ($info['value'] == 'on')  {
	        $type = $info['type'];
	        $shortocde = '[show_'.$type.']';
	        echo do_shortcode($shortocde); 
	    }
	}
    // After widget code, if any  
    echo $after_widget;
  }
 
  public function form( $instance ) {
   
     // PART 1: Extract the data from the instance variable
     $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
     $title = $instance['title'];
   	 $addresses = $instance['addresses'];
   	 $addresses_pos = $instance['addresses_pos'];
  	 $phones = $instance['phones']; 
  	 $phones_pos = $instance['phones_pos']; 
     $emails = $instance['emails']; 
     $emails_pos = $instance['emails_pos']; 
     $social = $instance['social']; 
     $social_pos = $instance['social_pos']; 
	  
     // PART 2-3: Display the fields
     ?>
    <!-- Widget title START -->
     <p>
      <label for="<?php echo $this->get_field_id('title'); ?>">Title: 
        <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" 
               name="<?php echo $this->get_field_name('title'); ?>" type="text" 
               value="<?php echo attribute_escape($title); ?>" />
      </label>
      </p>
      <!-- Widget title END -->
      
	  <!-- Widget address1 START -->
     <p>
      <label for="<?php echo $this->get_field_id('addresses'); ?>">  
        <input class="widefat" id="<?php echo $this->get_field_id('addresses'); ?>" 
               name="<?php echo $this->get_field_name('addresses'); ?>" type="checkbox" 
               <?php if (isset($addresses)) echo 'checked';?> /> Show addresses - Position 
               <input class="widefat" id="<?php echo $this->get_field_id('addresses_pos'); ?>" 
               name="<?php echo $this->get_field_name('addresses_pos'); ?>" type="number" placeholder="1" style="width: 50px;"
               value="<?php echo attribute_escape($addresses_pos); ?>" /> 
      </label>
      </p>
      <!-- Widget address1 END -->
	<!-- Widget phone1 START -->
     <p>
      <label for="<?php echo $this->get_field_id('phones'); ?>"> 
        <input class="widefat" id="<?php echo $this->get_field_id('phones'); ?>" 
               name="<?php echo $this->get_field_name('phones'); ?>" type="checkbox" 
               <?php if (isset($phones)) echo 'checked';?> /> Show Phones - Position 
               <input class="widefat" id="<?php echo $this->get_field_id('phones_pos'); ?>" 
               name="<?php echo $this->get_field_name('phones_pos'); ?>" type="number" placeholder="2"  style="width: 50px;"
               value="<?php echo attribute_escape($phones_pos); ?>" /> 
      </label>
      </p>
      <!-- Widget phone1 END -->
   
     <!-- Widget email START -->
     <p>
      <label for="<?php echo $this->get_field_id('emails'); ?>"> 
        <input class="widefat" id="<?php echo $this->get_field_id('emails'); ?>" 
               name="<?php echo $this->get_field_name('emails'); ?>" type="checkbox" 
               <?php if (isset($emails)) echo 'checked';?>  /> Show Emails - Position
               <input class="widefat" id="<?php echo $this->get_field_id('emails_pos'); ?>" 
               name="<?php echo $this->get_field_name('emails_pos'); ?>" type="number" placeholder="4"  style="width: 50px;"
               value="<?php echo attribute_escape($emails_pos); ?>" /> 
      </label>
      </p>
      <!-- Widget email END -->
   
     <!-- Widget social START -->
     <p>
      <label for="<?php echo $this->get_field_id('social'); ?>"> 
        <input class="widefat" id="<?php echo $this->get_field_id('social'); ?>" 
               name="<?php echo $this->get_field_name('social'); ?>" type="checkbox" 
               <?php if (isset($social)) echo 'checked';?>  /> Show Social - Position
               <input class="widefat" id="<?php echo $this->get_field_id('social_pos'); ?>" 
               name="<?php echo $this->get_field_name('social_pos'); ?>" type="number" placeholder="5"  style="width: 50px;"
               value="<?php echo attribute_escape($social_pos); ?>" /> 
      </label>
      </p>
      <!-- Widget social END -->
     <?php
   
  }
 
  function update($new_instance, $old_instance) {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['addresses'] = $new_instance['addresses'];
  	$instance['phones'] = $new_instance['phones'];
    $instance['emails'] = $new_instance['emails'];
    $instance['social'] = $new_instance['social'];
    $instance['addresses_pos'] = $new_instance['addresses_pos'];
  	$instance['phones_pos'] = $new_instance['phones_pos'];
    $instance['emails_pos'] = $new_instance['emails_pos'];
    $instance['social_pos'] = $new_instance['social_pos'];
    return $instance;
  }
  
}

add_action ( 'widgets_init', 'contact_info_register' );
function contact_info_register() {
    return register_widget('contact_info');
}



function show_addresses($atts, $content = null) {
    $return = '';
    if (custom_get_theme_option('address_1') || custom_get_theme_option('address_2')) { 
        $return .= '<div class="custom-icon map">';
            //$return .= '<span class="icon">'.do_shortcode('[icon_map]').'</span>';
            $return .= '<div class="icon-title">ADDRESS:</div>';
            $return .= '<div class="icon-info">';
                if (custom_get_theme_option('address_1')) {
                    $return .= '<p>';
                    if (custom_get_theme_option('gmap_1')) $return .= '<a href="'.custom_get_theme_option('gmap_1').'" target="_blank">';
                    $return .= str_replace('|',',<br>',custom_get_theme_option('address_1'));
                    if (custom_get_theme_option('gmap_1')) $return .= '</a>';
                    $return .= '</p>';
                }
                if (custom_get_theme_option('address_1')) {
                    $return .= '<p>';
                    if (custom_get_theme_option('gmap_2')) $return .= '<a href="'.custom_get_theme_option('gmap_2').'" target="_blank">';
                    $return .= str_replace('|',',<br>',custom_get_theme_option('address_2'));
                    if (custom_get_theme_option('gmap_2')) $return .= '</a>';
                    $return .= '</p>';
                }
            $return .= '</div>';
        $return .= '</div>';
    }
    return $return;
}
add_shortcode('show_addresses', 'show_addresses');


function show_phones($atts, $content = null) {
    $return = '';
    if (custom_get_theme_option('phone_1') || custom_get_theme_option('phone_2') || custom_get_theme_option('mobile_1') || custom_get_theme_option('mobile_2')) { 
        $return .= '<div class="custom-icon phone">';
            //$return .= '<span class="icon">'.do_shortcode('[icon_mobile]').'</span>';
            $return .= '<div class="icon-title">TELEPHONE:</div>';
            $return .= '<div class="icon-info">';
                if (custom_get_theme_option('phone_1')) {
                    $return .= '<p class="phone-info">';
                    $return .= '<a href="tel:'.custom_get_theme_option('phone_1').'" target="_blank">';
                    $return .= custom_get_theme_option('phone_1');
                    //$return .= ' <span class="contacthours">10:00-22:00</span>';
                    $return .= '</a>';
                    $return .= '</p>';
                }
                if (custom_get_theme_option('phone_2')) {
                    $return .= '<p class="phone-info">';
                    $return .= '<a href="tel:'.custom_get_theme_option('phone_2').'" target="_blank">';
                    $return .= custom_get_theme_option('phone_2');
                    //$return .= ' <span class="contacthours">10:00-22:00</span>';
                    $return .= '</a>';
                    $return .= '</p>';
                }
                if (custom_get_theme_option('mobile_1')) {
                    $return .= '<p class="mobile-info">';
                    $return .= '<a href="tel:'.custom_get_theme_option('mobile_1').'" target="_blank">';
                    $return .= custom_get_theme_option('mobile_1');
                    //$return .= ' <span class="contacthours">10:00-20:00</span>';
                    $return .= '</a>';
                    $return .= '</p>';
                }
                if (custom_get_theme_option('mobile_2')) {
                    $return .= '<p class="mobile-info">';
                    $return .= '<a href="tel:'.custom_get_theme_option('mobile_2').'" target="_blank">';
                    $return .= custom_get_theme_option('mobile_2');
                    //$return .= ' <span class="contacthours">10:00-20:00</span>';
                    $return .= '</a>';
                    $return .= '</p>';
                }
            $return .= '</div>';
        $return .= '</div>';
    }
    return $return;
}
add_shortcode('show_phones', 'show_phones');


function show_emails($atts, $content = null) {
    $return = '';
    if (custom_get_theme_option('email_1') || custom_get_theme_option('email_2')) { 
        $return .= '<div class="custom-icon email">';
            $return .= '<div class="icon-title">EMAIL:</div>';
            //$return .= '<span class="icon">'.do_shortcode('[icon_email]').'</span>';
            $return .= '<div class="icon-info">';
                if (custom_get_theme_option('email_1')) {
                    $return .= '<p>';
                    $return .= '<a href="mailto:'.custom_get_theme_option('email_1').'" target="_blank">';
                    $return .= custom_get_theme_option('email_1');
                    $return .= '</a>';
                    $return .= '</p>';
                }
                if (custom_get_theme_option('email_2')) {
                    $return .= '<p>';
                    $return .= '<a href="mailto:'.custom_get_theme_option('email_2').'" target="_blank">';
                    $return .= custom_get_theme_option('email_2');
                    $return .= '</a>';
                    $return .= '</p>';
                }
            $return .= '</div>';
        $return .= '</div>';
    } 
    return $return;
}
add_shortcode('show_emails', 'show_emails');


function show_social($atts, $content = null) {
    $return = '';
    if (custom_get_theme_option('facebook') || custom_get_theme_option('instagram') || custom_get_theme_option('youtube') || custom_get_theme_option('twitter') || custom_get_theme_option('linkedin') || custom_get_theme_option('pinterest')) { 
        $return .= '<div class="custom-icon social">';
            $return .= '<ul>';
                if (custom_get_theme_option('facebook')) {
                    $icon = 'facebook';
                    $return .= '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <path d="M43,14.2H23.4c-5.2,0-9.5,4.3-9.5,9.5v19.6c0,5.2,4.3,9.5,9.5,9.5H43c5.2,0,9.5-4.3,9.5-9.5V23.7 C52.5,18.4,48.2,14.2,43,14.2z M50.5,43.3c0,4.1-3.4,7.5-7.5,7.5h-5.8V35h3.9v-2.2h-3.9v-2.2c0-3.1,0.8-4.4,2.7-4.4 c0.5,0,1.4,0.1,1.9,0.2l0.3,0.1v-2.2l-0.2-0.1c-0.4-0.1-1.3-0.3-1.9-0.3c-3.4,0-5.2,2.3-5.2,6.6v2.3h-3.1V35h3.1v15.8H23.4 c-4.1,0-7.5-3.4-7.5-7.5V23.7c0-4.1,3.4-7.5,7.5-7.5H43c4.1,0,7.5,3.4,7.5,7.5V43.3z"/> </svg>
                    </a></li>';
                }
                if (custom_get_theme_option('instagram')) {
                    $icon = 'instagram';
                    $return .=  '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <path d="M43,14.2H23.4c-5.2,0-9.5,4.3-9.5,9.5v19.6c0,5.2,4.3,9.5,9.5,9.5H43c5.2,0,9.5-4.3,9.5-9.5V23.7 C52.5,18.4,48.2,14.2,43,14.2z M50.5,43.3c0,4.1-3.4,7.5-7.5,7.5H23.4c-4.1,0-7.5-3.4-7.5-7.5V23.7c0-4.1,3.4-7.5,7.5-7.5H43 c4.1,0,7.5,3.4,7.5,7.5V43.3z"/> <path d="M33.2,24.4c-5,0-9.1,4.1-9.1,9.1c0,5,4.1,9.1,9.1,9.1s9.1-4.1,9.1-9.1C42.3,28.5,38.2,24.4,33.2,24.4z M33.2,40.6 c-3.9,0-7.1-3.2-7.1-7.1s3.2-7.1,7.1-7.1s7.1,3.2,7.1,7.1S37.1,40.6,33.2,40.6z"/> <path d="M42.8,22.6c-0.8,0-1.5,0.7-1.5,1.5s0.7,1.5,1.5,1.5c0.8,0,1.5-0.7,1.5-1.5S43.7,22.6,42.8,22.6z"/> </g> </svg>
                    </a></li>';
                }
                if (custom_get_theme_option('youtube')) {
                    $icon = 'youtube';
                    $return .=  '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <path d="M44,19H22.4c-4.6,0-8.4,3.8-8.4,8.4v12.2c0,4.6,3.8,8.4,8.4,8.4H44c4.6,0,8.4-3.8,8.4-8.4V27.4C52.4,22.8,48.6,19,44,19z M50.7,39.6c0,3.7-3,6.7-6.7,6.7H22.4c-3.7,0-6.7-3-6.7-6.7V27.4c0-3.7,3-6.7,6.7-6.7H44c3.7,0,6.7,3,6.7,6.7V39.6z"/> <path d="M29.8,26.8c-0.3-0.2-0.6-0.2-0.9,0c-0.3,0.2-0.4,0.4-0.4,0.8v12.3c0,0.3,0.2,0.6,0.5,0.8c0.1,0.1,0.3,0.1,0.4,0.1 c0.2,0,0.3,0,0.5-0.1l9.7-6.3c0.2-0.2,0.4-0.4,0.4-0.7c0-0.3-0.2-0.6-0.4-0.7L29.8,26.8z M30.2,38.2V29l7.2,4.5L30.2,38.2z"/> </g> </svg>
                    </a></li>';
                }
                if (custom_get_theme_option('twitter')) {
                    $icon = 'twitter';
                    $return .=  '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <path d="M32.2,28.4c-2.2,0-7.9-0.8-14.7-7.4c-0.6,0.9-1.3,2.6,0,4.7c0.3,0.4,0.1,0.9-0.3,1.2c-0.4,0.3-0.9,0.1-1.2-0.3 c-2.1-3.4-0.4-6.4,0.8-7.5c0.3-0.3,0.9-0.3,1.2,0c6.5,6.7,12,7.5,14,7.5c-0.1-1.7,0.1-5.1,3.5-7.9c4.1-3.2,9.6,0.1,11.2,1.2 l4.6-2.2c0.4-0.2,0.8-0.1,1,0.2c0.3,0.3,0.3,0.7,0,1.1L49,23.8c-0.3,0.4-0.8,0.5-1.2,0.2c-0.4-0.3-0.5-0.8-0.2-1.2l1.5-2l-2,0.9 c-0.3,0.1-0.6,0.1-0.9-0.1c-0.1,0-5.8-4.4-9.5-1.5c-3.7,3-2.8,6.9-2.8,7.1c0.1,0.2,0,0.5-0.1,0.7c-0.1,0.2-0.3,0.3-0.6,0.4 C33.1,28.3,32.8,28.4,32.2,28.4z"/> <path d="M17.7,35.1c-0.2,0-0.4-0.1-0.6-0.2c-2.2-2.2-2.1-5.8-2.1-6c0-0.3,0.2-0.5,0.4-0.7c0.2-0.1,0.5-0.2,0.8-0.1l3.6,1.5 c0.4,0.2,0.6,0.7,0.5,1.1c-0.2,0.4-0.7,0.6-1.1,0.5l-2.3-1c0.1,1,0.5,2.4,1.5,3.3c0.3,0.3,0.3,0.9,0,1.2 C18.1,35.1,17.9,35.1,17.7,35.1z"/> <path d="M22.7,42.2c-0.1,0-0.3,0-0.4-0.1c-4.4-2.3-4.8-5-4.8-5.3c0-0.2,0.1-0.5,0.2-0.7c0.2-0.2,0.4-0.3,0.6-0.3h4.4 c0.5,0,0.9,0.4,0.9,0.9s-0.4,0.9-0.9,0.9h-3.1c0.5,0.8,1.5,1.9,3.5,3c0.4,0.2,0.6,0.7,0.4,1.2C23.3,42.1,23,42.2,22.7,42.2z"/> <path d="M29.2,49.6c-7.6,0-14.5-3.6-14.9-3.8c-0.4-0.2-0.6-0.6-0.4-1c0.1-0.4,0.5-0.6,1-0.6c6.4,1.2,10-2.4,10.2-2.6 c0.3-0.3,0.9-0.3,1.2,0c0.3,0.3,0.3,0.9,0,1.2c-0.1,0.1-2.6,2.6-6.9,3.2c4.6,1.6,12.1,3.2,18.2-0.1c5.6-3,8.9-9.5,9.9-19.3 c0-0.5,0.5-0.8,0.9-0.8c0.5,0,0.8,0.5,0.8,0.9c-1.1,10.4-4.7,17.3-10.9,20.6C35.4,49,32.2,49.6,29.2,49.6z"/> </g> </svg>
                    </a></li>';
                }
                if (custom_get_theme_option('linkedin')) {
                    $icon = 'linkedin';
                    $return .=  '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <circle cx="23.1" cy="36.4" r="2.3"/> <circle cx="42.9" cy="36.3" r="2.3"/> <path d="M55.9,25.1c0,0-4.4,0.2-8.5,0.4c-1.4-1.6-6-5.9-14.2-5.8c-9,0.1-12.5,4.8-13.2,5.8c-4.3-0.3-9.4-0.5-9.4-0.5l4.4,4.6 c-1.5,1.8-2.4,4.1-2.4,6.7c0,5.8,4.7,10.5,10.5,10.5c3.2,0,6.1-1.5,8-3.7l2,4.1l2-3.9c1.9,2.1,4.7,3.5,7.8,3.5 c5.8,0,10.5-4.7,10.5-10.5c0-2.4-0.8-4.6-2.2-6.4L55.9,25.1z M33.2,21.4c0,0,0.1,0,0.1,0c5.9,0,9.8,2.5,11.7,4.2 c-0.6,0-1.1,0.1-1.6,0.1c-0.2,0-0.3,0-0.5,0c-4.6,0-8.5,3-9.9,7.1c-1.2-3.4-4.1-6-7.7-6.7l0.1,0c-0.4-0.1-1.7-0.3-3.4-0.4 C23.3,24.2,26.6,21.5,33.2,21.4z M23.1,45.2c-4.9,0-8.8-4-8.8-8.8c0-4.9,4-8.8,8.8-8.8c4.9,0,8.8,4,8.8,8.8 C31.9,41.2,28,45.2,23.1,45.2z M42.9,45.1c-4.9,0-8.8-4-8.8-8.8c0-4.9,4-8.8,8.8-8.8c4.9,0,8.8,4,8.8,8.8 C51.8,41.1,47.8,45.1,42.9,45.1z"/> </g> </svg>
                    </a></li>';
                }
                if (custom_get_theme_option('pinterest')) {
                    $icon = 'pinterest';
                    $return .=  '<li class="'.$icon.'"><a href="'.custom_get_theme_option($icon).'" target="_blank">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <path d="M47.6,25.2c-1.5-5.1-6-9.1-9.4-10c-5.8-1.5-15.8,0-19,8.2c-3.2,8.2,2.2,12.3,2.2,12.3c0.4,0.3,0.9,0.2,1.2-0.2 c0.3-0.4,0.2-0.9-0.2-1.2c-0.2-0.1-4.4-3.4-1.7-10.3c2.7-6.9,11.6-8.6,17-7.1c2.9,0.8,6.8,4.4,8.2,8.9c0.8,2.6,0.9,6.5-2.6,10.4 c-2,2.2-4.2,3.3-6.5,3.3c0,0,0,0,0,0c-3.5,0-6.5-2.6-7.4-3.5l2.8-11.6c0.1-0.5-0.2-0.9-0.6-1c-0.5-0.1-0.9,0.2-1,0.6L24,51.3 c-0.1,0.5,0.2,0.9,0.6,1c0.1,0,0.1,0,0.2,0c0.4,0,0.7-0.3,0.8-0.7l3.3-13.9c1.5,1.3,4.4,3.3,7.8,3.3c0,0,0,0,0,0 c2.8,0,5.4-1.3,7.7-3.9C48.7,32.7,48.5,28.2,47.6,25.2z"/> </svg>
                    </a></li>';
                }
            $return .= '</ul>';
        $return .= '</div>';
    }
    return $return;
}
add_shortcode('show_social', 'show_social');
?>