<?php

// Sliders
$slider = custom_get_theme_option( 'enable_slider' );
if ($slider == 'on')
require_once('post-types/post-type-slider.php');


/*
function exclude_page_template_store( $post_templates ) {
    $store = custom_get_theme_option( 'enable_store' );
    if ($store != 'on') {
        unset( $post_templates['templates/page-stores.php'] );
    }
    return $post_templates;
}
add_filter( 'theme_page_templates', 'exclude_page_template_store' );
*/




// Logos
$online_menus = custom_get_theme_option( 'enable_gallery' );
if ($online_menus == 'on')
require_once('post-types/post-type-gallery.php');



function show_contact_informations() { ?>
    <?php $current_lang = apply_filters( 'wpml_current_language', NULL );
    
    $languages = apply_filters( 'wpml_active_languages', NULL, 'skip_missing=0&orderby=code' );
    
    
    ?>
	<h3>Contact Info Page</h3>
	
	<table class="form-table wpex-custom-admin-login-table">
        <style>input[type="text"], textarea {width:100%;}</style>
        <?php foreach ($languages as $lang=>$lang_data) { ?>
		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Address 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'address_1_'.$lang ); ?>
                <input type="text" name="theme_options[address_1_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>" placeholder="Use | to break line">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Google Maps Url 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'gmap_1_'.$lang ); ?>
                <input type="text" name="theme_options[gmap_1_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Address 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'address_2_'.$lang ); ?>
                <input type="text" name="theme_options[address_2_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>" placeholder="Use | to break line">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Google Maps Url 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'gmap_2_'.$lang ); ?>
                <input type="text" name="theme_options[gmap_2_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>
		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Phone 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'phone_1_'.$lang ); ?>
                <input type="text" name="theme_options[phone_1_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Phone 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'phone_2_'.$lang ); ?>
                <input type="text" name="theme_options[phone_2_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Mobile 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'mobile_1_'.$lang ); ?>
                <input type="text" name="theme_options[mobile_1_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Mobile 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'mobile_2_'.$lang ); ?>
                <input type="text" name="theme_options[mobile_2_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Email 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'email_1_'.$lang ); ?>
                <input type="text" name="theme_options[email_1_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'Contact Email 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'email_2_'.$lang ); ?>
                <input type="text" name="theme_options[email_2_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'IFrame Map 1', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'iframe_1_'.$lang ); ?>
                <textarea rows="8" name="theme_options[iframe_1_<?php echo $lang;?>]"><?php echo esc_attr( $value ); ?></textarea>
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<th scope="row"><?php esc_html_e( 'IFrame Map 2', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'iframe_2_'.$lang ); ?>
                <textarea rows="8" name="theme_options[iframe_2_<?php echo $lang;?>]"><?php echo esc_attr( $value ); ?></textarea>
			</td>
		</tr>

		
		<?php // Select example ?>
		<!--<tr valign="top" class="wpex-custom-admin-screen-background-section">
			<th scope="row"><?php esc_html_e( 'Select Example', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'select_example' ); ?>
                <select name="theme_options[select_example]">
                	<?php
                	$options = array(
                		'1' => esc_html__( 'Option 1', 'airtec' ),
                		'2' => esc_html__( 'Option 2', 'airtec' ),
                		'3' => esc_html__( 'Option 3', 'airtec' ),
                	);
                	foreach ( $options as $id => $label ) { ?>
                		<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $value, $id, true ); ?>>
                			<?php echo strip_tags( $label ); ?>
                		</option>
                	<?php } ?>
                </select>
			</td>
		</tr>-->
        <?php } ?>
	</table>
<?php } 


function show_store_informations() { ?>
    <?php $lang_current = apply_filters( 'wpml_current_language', NULL );
    
    
    $languages = apply_filters( 'wpml_active_languages', NULL, 'skip_missing=0&orderby=code' );
    echo '<style>';
    foreach ($languages as $lang=>$lang_data) {
        echo 'tr.tr-'.$lang.'{display:none;}';
    }
        echo 'tr.tr-'.$lang_current.'{display:table-row;}';
    echo '</style>';
    ?>
	<h3>Working Hours</h3>
	<table class="form-table wpex-custom-admin-login-table">

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Monday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'monday' ); ?>
                <input type="text" name="theme_options[monday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Tuesday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'tuesday' ); ?>
                <input type="text" name="theme_options[tuesday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Wednesday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'wednesday' ); ?>
                <input type="text" name="theme_options[wednesday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Thursday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'thursday' ); ?>
                <input type="text" name="theme_options[thursday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Firday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'friday' ); ?>
                <input type="text" name="theme_options[friday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Saturday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'saturday' ); ?>
                <input type="text" name="theme_options[saturday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Sunday', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'sunday' ); ?>
                <input type="text" name="theme_options[sunday]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

        <?php foreach ($languages as $lang=>$lang_data) { ?>
		<tr class="tr-<?php echo $lang;?>" valign="top">
			<td>
                <?php $value = custom_get_theme_option( 'days_1_name_'.$lang ); ?>
                <input type="text" name="theme_options[days_1_name_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>" placeholder="Custom Text Hours">
			</td>
			<td>
                <?php $value = custom_get_theme_option( 'days_1_val_'.$lang ); ?>
                <input type="text" name="theme_options[days_1_val_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>"  placeholder="Hours">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<td>
                <?php $value = custom_get_theme_option( 'days_2_name_'.$lang ); ?>
                <input type="text" name="theme_options[days_2_name_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>" placeholder="Custom Text Hours">
			</td>
			<td>
                <?php $value = custom_get_theme_option( 'days_2_val_'.$lang ); ?>
                <input type="text" name="theme_options[days_2_val_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>"  placeholder="Hours">
			</td>
		</tr>

		<tr class="tr-<?php echo $lang;?>" valign="top">
			<td>
                <?php $value = custom_get_theme_option( 'days_3_name_'.$lang ); ?>
                <input type="text" name="theme_options[days_3_name_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>" placeholder="Custom Text Hours">
			</td>
			<td>
                <?php $value = custom_get_theme_option( 'days_3_val_'.$lang ); ?>
                <input type="text" name="theme_options[days_3_val_<?php echo $lang;?>]" value="<?php echo esc_attr( $value ); ?>"  placeholder="Hours">
			</td>
		</tr>

		<?php // Select example ?>
		<!--<tr valign="top" class="wpex-custom-admin-screen-background-section">
			<th scope="row"><?php esc_html_e( 'Select Example', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'select_example' ); ?>
                <select name="theme_options[select_example]">
                	<?php
                	$options = array(
                		'1' => esc_html__( 'Option 1', 'airtec' ),
                		'2' => esc_html__( 'Option 2', 'airtec' ),
                		'3' => esc_html__( 'Option 3', 'airtec' ),
                	);
                	foreach ( $options as $id => $label ) { ?>
                		<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $value, $id, true ); ?>>
                			<?php echo strip_tags( $label ); ?>
                		</option>
                	<?php } ?>
                </select>
			</td>
		</tr>-->

        <?php } ?>
	</table>
<?php } 

function show_advanced_tabs() { ?>


	<table class="form-table wpex-custom-admin-login-table">

		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Enable Gallery', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'enable_gallery' ); ?>
                <input type="checkbox" name="theme_options[enable_gallery]" <?php checked( $value, 'on' ); ?>> 
			</td>
		</tr>
		<?php /* ?>
		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Enable Galleries', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'enable_logos' ); ?>
                <input type="checkbox" name="theme_options[enable_logos]" <?php checked( $value, 'on' ); ?>> 
			</td>
		</tr>
		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Enable Events', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'enable_events' ); ?>
                <input type="checkbox" name="theme_options[enable_events]" <?php checked( $value, 'on' ); ?>> 
			</td>
		</tr>
		<tr valign="top">
			<th scope="row"><?php esc_html_e( 'Enable Testimonials', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'enable_testimonials' ); ?>
                <input type="checkbox" name="theme_options[enable_testimonials]" <?php checked( $value, 'on' ); ?>> 
			</td>
		</tr>

		<?php */ ?>
	</table>
	
<?php } 






function show_social_tabs() { ?>

	<h3>Social Urls</h3>
	<table class="form-table wpex-custom-admin-login-table">
        <?php $value_pos = custom_get_theme_option( 'social_pos' );?>
		<tr valign="top">
            <?php $fb_pos = $value_pos['facebook']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $fb_pos;?>" name="theme_options[social_pos][facebook]">&nbsp;&nbsp;<?php esc_html_e( 'Facebook', 'airtec' ); ?></th>
			<td>
                <?php $value = custom_get_theme_option( 'facebook' ); ?>
                <input type="text" name="theme_options[facebook]" value="<?php echo esc_attr( $value ); ?>">
			</td style="width: 100%;">
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['instagram']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][instagram]">&nbsp;&nbsp;<?php esc_html_e( 'Instagram', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'instagram' ); ?>
                <input type="text" name="theme_options[instagram]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['youtube']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][youtube]">&nbsp;&nbsp;<?php esc_html_e( 'Youtube', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'youtube' ); ?>
                <input type="text" name="theme_options[youtube]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['tiktok']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][tiktok]">&nbsp;&nbsp;<?php esc_html_e( 'TikTok', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'tiktok' ); ?>
                <input type="text" name="theme_options[tiktok]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['twitter']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][twitter]">&nbsp;&nbsp;<?php esc_html_e( 'Twitter', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'twitter' ); ?>
                <input type="text" name="theme_options[twitter]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['linkedin']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][linkedin]">&nbsp;&nbsp;<?php esc_html_e( 'Linkedin', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'linkedin' ); ?>
                <input type="text" name="theme_options[linkedin]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['pinterest']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][pinterest]">&nbsp;&nbsp;<?php esc_html_e( 'Pinterest', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'pinterest' ); ?>
                <input type="text" name="theme_options[pinterest]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>
		
		<tr valign="top">
            <?php $value_pos = custom_get_theme_option( 'social_pos' ); $value_pos = $value_pos['tripadvisor']; ?>
			<th scope="row" style=" display: flex; flex-direction: row; align-items: center; "><input style="width:80px;float:left;" type="number" placeholder="Pos." value="<?php echo $value_pos;?>" name="theme_options[social_pos][tripadvisor]">&nbsp;&nbsp;<?php esc_html_e( 'Tripadvisor', 'airtec' ); ?></th>
			<td style="width: 100%;">
                <?php $value = custom_get_theme_option( 'tripadvisor' ); ?>
                <input type="text" name="theme_options[tripadvisor]" value="<?php echo esc_attr( $value ); ?>">
			</td>
		</tr>

	</table>
<?php } 



//add_action('wp_head', 'custom_theme_css');
function custom_theme_css(){
	wp_deregister_style('airtec-settings');
	wp_register_style('airtec-settings', (get_template_directory_uri()."/assets/scripts/css/theme-styles.php"), false, false, 'all');
	wp_enqueue_style('airtec-settings');
}


  


function image_uploader_enqueue_theme() {
        wp_enqueue_media();

        wp_register_script( 'meta-image', get_template_directory_uri() . '/assets/scripts/js/media-uploader.js', array( 'jquery' ) );
        wp_localize_script( 'meta-image', 'meta_image',
            array(
                'title' => 'Upload an Image',
                'button' => 'Use this Image',
            )
        );
        wp_enqueue_script( 'meta-image' );
}
add_action( 'admin_enqueue_scripts', 'image_uploader_enqueue_theme' );



function show_logo_theme() {
    ?>
    <?php $value = custom_get_theme_option( 'site_logo' ); ?>
    <table class="form-table">
        <tbody>
            <tr class="form-field term-name-wrap">
			    <th scope="row"><label for="name">LOGO</label></th>
			    <td>
			    <img src="<?php echo $value;?>" id="bg_img_url" style="max-width: 100%;">
                <input type="hidden" name="theme_options[site_logo]" id="bg_img" value="<?php echo esc_attr( $value ); ?>">
                <br>
                <input type="button" id="upload_image_btn" class="button" value="Upload Image"/> 
                <?php if ($value) { ?>
                    <input type="button" id="delete_image_btn" class="button" value="Delete Image"/> 
                <?php } ?>
			    </td>
		    </tr>
        </tbody>
    </table>
    <?php
}


function show_font_theme() {
    ?>
    <h3>Desktop</h3>
    <h4>Menu</h4>
    
    <?php $value = custom_get_theme_option( 'site_logo' ); ?>
    <table class="form-table">
        <tbody>
            <tr class="form-field term-name-wrap">
			    <th scope="row"><label for="name">Font Size</label></th>
			    <td>
			    <img src="<?php echo $value;?>" id="bg_img_url" style="max-width: 100%;">
                <input type="hidden" name="theme_options[site_logo]" id="bg_img" value="<?php echo esc_attr( $value ); ?>">
                <br>
                <input type="button" id="upload_image_btn" class="button" value="Upload Image"/> 
                <?php if ($value) { ?>
                    <input type="button" id="delete_image_btn" class="button" value="Delete Image"/> 
                <?php } ?>
			    </td>
		    </tr>
        </tbody>
    </table>
    
    
    <h4>Sub Menu</h4>
    
    <hr>
    <h3>Mobile</h3>
    <?php
}
