<?php

if (function_exists('add_theme_support')){
	// Add Menu Support
	add_theme_support('menus');

	// Add Thumbnail Theme Support
	add_theme_support('post-thumbnails');
	//add_image_size('large', 700, '', true); // Large Thumbnail
	//add_image_size('medium', 250, '', true); // Medium Thumbnail
	//add_image_size('small', 120, '', true); // Small Thumbnail
	//add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');

	// Add Support for Custom Backgrounds - Uncomment below if you're going to use
	/*add_theme_support('custom-background', array(
	'default-color' => 'FFF',
	'default-image' => get_template_directory_uri() . '/img/bg.jpg' 
	));*/

	// Add Support for Custom Header - Uncomment below if you're going to use
	/*add_theme_support('custom-header', array(
	'default-image'          => get_template_directory_uri() . '/img/headers/default.jpg',
	'header-text'            => false,
	'default-text-color'     => '000',
	'width'                  => 1000,
	'height'                 => 198,
	'random-default'         => false,
	'wp-head-callback'       => $wphead_cb,
	'admin-head-callback'    => $adminhead_cb,
	'admin-preview-callback' => $adminpreview_cb
	));*/

	//Add Post Formats support
	add_theme_support( 'structured-post-formats', array( 'link', 'video' ) );
	add_theme_support( 'post-formats', array( 'aside', 'gallery', 'image', 'quote', 'status', 'audio', 'chat' ) );
	add_post_type_support( 'post', 'post-formats' );
	add_post_type_support( 'page', 'post-formats' );

	// Enables post and comment RSS feed links to head
	add_theme_support('automatic-feed-links');

	// Localisation Support
	load_theme_textdomain('airtec', get_template_directory() . '/languages');

}



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Start Class
if ( ! class_exists( 'Custom_Theme_Options' ) ) {

	class Custom_Theme_Options {

		/**
		 * Start things up
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			// We only need to register the admin panel on the back-end
			if ( is_admin() ) {
				add_action( 'admin_menu', array( 'Custom_Theme_Options', 'add_admin_menu' ) );
				add_action( 'admin_init', array( 'Custom_Theme_Options', 'register_settings' ) );
			}

		}

		/**
		 * Returns all theme options
		 *
		 * @since 1.0.0
		 */
		public static function get_theme_options() {
			return get_option( 'theme_options' );
		}

		/**
		 * Returns single theme option
		 *
		 * @since 1.0.0
		 */
		public static function get_theme_option( $id ) {
			$options = self::get_theme_options();
			if ( isset( $options[$id] ) ) {
				return $options[$id];
			}
		}

		/**
		 * Add sub menu page
		 *
		 * @since 1.0.0
		 */
		public static function add_admin_menu() {
			add_menu_page(
				esc_html__( 'Theme Settings', 'airtec' ),
				esc_html__( 'Theme Settings', 'airtec' ),
				'manage_options',
				'theme-settings',
				array( 'Custom_Theme_Options', 'create_admin_page' )
			);
		}

		/**
		 * Register a setting and its sanitization callback.
		 *
		 * We are only registering 1 setting so we can store all options in a single option as
		 * an array. You could, however, register a new setting for each option
		 *
		 * @since 1.0.0
		 */
		public static function register_settings() {
			register_setting( 'theme_options', 'theme_options', array( 'Custom_Theme_Options', 'sanitize' ) );
		}

		/**
		 * Sanitization callback
		 *
		 * @since 1.0.0
		 */
		public static function sanitize( $options ) {

			// If we have options lets sanitize them
			if ( $options ) {


                $current_lang = apply_filters( 'wpml_current_language', NULL );;
                $languages = apply_filters( 'wpml_active_languages', NULL, 'skip_missing=0&orderby=code' );
                    foreach ($languages as $lang=>$lang_data) {
    				// Monday
    				if ( ! empty( $options['monday_1_'.$lang] ) ) {
    					$options['monday_1_'.$lang] = sanitize_text_field( $options['monday_1_'.$lang] );
    				} else {
    					//unset( $options['monday_1_'.$lang] ); 
    				}
    
    				// Tuesday
    				if ( ! empty( $options['tuesday_1_'.$lang] ) ) {
    					$options['tuesday_1_'.$lang] = sanitize_text_field( $options['tuesday_1_'.$lang] );
    				} else {
    					//unset( $options['tuesday_1_'.$lang] ); 
    				}
    
    				// Wednsday
    				if ( ! empty( $options['wednsesday_1_'.$lang] ) ) {
    					$options['wednsesday_1_'.$lang] = sanitize_text_field( $options['wednsesday_1_'.$lang] );
    				} else {
    					//unset( $options['wednsesday_1_'.$lang] ); 
    				}
    
    				// Thurday
    				if ( ! empty( $options['thursday_1_'.$lang] ) ) {
    					$options['thursday_1_'.$lang] = sanitize_text_field( $options['thursday_1_'.$lang] );
    				} else {
    					//unset( $options['thursday_1_'.$lang] ); 
    				}
    
    				// Friday
    				if ( ! empty( $options['friday_1_'.$lang] ) ) {
    					$options['friday_1_'.$lang] = sanitize_text_field( $options['friday_1_'.$lang] );
    				} else {
    					//unset( $options['friday_1_'.$lang] ); 
    				}
    
    				// Saturday
    				if ( ! empty( $options['saturday_1_'.$lang] ) ) {
    					$options['saturday_1_'.$lang] = sanitize_text_field( $options['saturday_1_'.$lang] );
    				} else {
    					//unset( $options['saturday_1_'.$lang] ); 
    				}
    
    
    				// Sunday
    				if ( ! empty( $options['sunday_1_'.$lang] ) ) {
    					$options['sunday_1_'.$lang] = sanitize_text_field( $options['sunday_1_'.$lang] );
    				} else {
    					//unset( $options['sunday_1_'.$lang] ); 
    				}
    
    
    				// days_1_name
    				if ( ! empty( $options['days_1_name_'.$lang] ) ) {
    					$options['days_1_name_'.$lang] = sanitize_text_field( $options['days_1_name_'.$lang] );
    				} else {
    					//unset( $options['days_1_name_'.$lang] ); 
    				}
    
    				// days_1_val
    				if ( ! empty( $options['days_1_val_'.$lang] ) ) {
    					$options['days_1_val_'.$lang] = sanitize_text_field( $options['days_1_val_'.$lang] );
    				} else {
    					//unset( $options['days_1_val_'.$lang] ); 
    				}
    
    
    				// days_1_name
    				if ( ! empty( $options['days_2_name_'.$lang] ) ) {
    					$options['days_2_name_'.$lang] = sanitize_text_field( $options['days_2_name_'.$lang] );
    				} else {
    					//unset( $options['days_2_name_'.$lang] ); 
    				}
    
    				// days_2_val
    				if ( ! empty( $options['days_2_val_'.$lang] ) ) {
    					$options['days_2_val_'.$lang] = sanitize_text_field( $options['days_2_val_'.$lang] );
    				} else {
    					//unset( $options['days_2_val_'.$lang] ); 
    				}
    
    				// days_3_val
    				if ( ! empty( $options['days_3_val_'.$lang] ) ) {
    					$options['days_3_val_'.$lang] = sanitize_text_field( $options['days_3_val_'.$lang] );
    				} else {
    					//unset( $options['days_3_val_'.$lang] ); 
    				}
    
    				// Iframe 1
    				if ( ! empty( $options['iframe_1_'.$lang] ) ) {
    					$options['iframe_1_'.$lang] =  $options['iframe_1_'.$lang] ;
    				} else {
    					//unset( $options['iframe_1_'.$lang] ); 
    				}
    
    				// Iframe 2
    				if ( ! empty( $options['iframe_2_'.$lang] ) ) {
    					$options['iframe_2_'.$lang] =  $options['iframe_2_'.$lang] ;
    				} else {
    					//unset( $options['iframe_2_'.$lang] ); 
    				}
    				
    				if ( ! empty( $options['iframe_airtec_'.$lang] ) ) {
    					$options['iframe_airtec_'.$lang] =  $options['iframe_airtec_'.$lang] ;
    				}
    
    				// Address 1
    				if ( ! empty( $options['address_1_'.$lang] ) ) {
    					$options['address_1_'.$lang] = sanitize_text_field( $options['address_1_'.$lang] );
    				} else {
    					//unset( $options['address_1_'.$lang] ); 
    				}
    
    				// Google Maps 1
    				if ( ! empty( $options['gmap_1_'.$lang] ) ) {
    					$options['gmap_1_'.$lang] = sanitize_text_field( $options['gmap_1_'.$lang] );
    				} else {
    					//unset( $options['gmap_1_'.$lang] ); 
    				}
    
    				// Address 2
    				if ( ! empty( $options['address_2_'.$lang] ) ) {
    					$options['address_2_'.$lang] = sanitize_text_field( $options['address_2_'.$lang] );
    				} else {
    					//unset( $options['address_2_'.$lang] ); 
    				}
    
    				// Google Maps 1
    				if ( ! empty( $options['gmap_2_'.$lang] ) ) {
    					$options['gmap_2_'.$lang] = sanitize_text_field( $options['gmap_2_'.$lang] );
    				} else {
    					//unset( $options['gmap_2_'.$lang] ); 
    				}
    
    
    				// Phone 1
    				if ( ! empty( $options['phone_1_'.$lang] ) ) {
    					$options['phone_1_'.$lang] = sanitize_text_field( $options['phone_1_'.$lang] );
    				} else {
    					//unset( $options['phone_1_'.$lang] ); 
    				}
    
    
    				// Phone 2
    				if ( ! empty( $options['phone_2_'.$lang] ) ) {
    					$options['phone_2_'.$lang] = sanitize_text_field( $options['phone_2_'.$lang] );
    				} else {
    					//unset( $options['phone_2_'.$lang] ); 
    				}
    
    
    				// Mobile 1
    				if ( ! empty( $options['mobile_1_'.$lang] ) ) {
    					$options['mobile_1_'.$lang] = sanitize_text_field( $options['mobile_1_'.$lang] );
    				} else {
    					//unset( $options['mobile_1_'.$lang] ); 
    				}
    
    
    				// Mobile 2
    				if ( ! empty( $options['mobile_2_'.$lang] ) ) {
    					$options['mobile_2_'.$lang] = sanitize_text_field( $options['mobile_2_'.$lang] );
    				} else {
    					//unset( $options['mobile_2_'.$lang] ); 
    				}
    
    
    				// Email 1
    				if ( ! empty( $options['email_1_'.$lang] ) ) {
    					$options['email_1_'.$lang] = sanitize_text_field( $options['email_1_'.$lang] ); 
    				} else {
    					//unset( $options['email_1_'.$lang] ); 
    				}
                }

				// Email 2
				if ( ! empty( $options['email_2_'.$lang] ) ) {
					$options['email_2_'.$lang] = sanitize_text_field( $options['email_2_'.$lang] );
				} else {
					//unset( $options['email_2_'.$lang] ); 
				}





				// Facebook
				if ( ! empty( $options['facebook'] ) ) {
					$options['facebook'] = sanitize_text_field( $options['facebook'] );
				} else {
					//unset( $options['facebook'] ); 
				}



				// instagram
				if ( ! empty( $options['instagram'] ) ) {
					$options['instagram'] = sanitize_text_field( $options['instagram'] );
				} else {
					//unset( $options['instagram'] ); 
				}



				// youtube
				if ( ! empty( $options['youtube'] ) ) {
					$options['youtube'] = sanitize_text_field( $options['youtube'] );
				} else {
					//unset( $options['youtube'] ); 
				}



				// twitter
				if ( ! empty( $options['twitter'] ) ) {
					$options['twitter'] = sanitize_text_field( $options['twitter'] );
				} else {
					//unset( $options['twitter'] ); 
				}



				// linkedin
				if ( ! empty( $options['linkedin'] ) ) {
					$options['linkedin'] = sanitize_text_field( $options['linkedin'] );
				} else {
					//unset( $options['linkedin'] ); 
				}



				// pinterest
				if ( ! empty( $options['pinterest'] ) ) {
					$options['pinterest'] = sanitize_text_field( $options['pinterest'] );
				} else {
					//unset( $options['pinterest'] ); 
				}

				// tripadvisor
				if ( ! empty( $options['tripadvisor'] ) ) {
					$options['tripadvisor'] = sanitize_text_field( $options['tripadvisor'] );
				} else {
					//unset( $options['tripadvisor'] ); 
				}

				// tripadvisor
				if ( ! empty( $options['tiktok'] ) ) {
					$options['tiktok'] = sanitize_text_field( $options['tiktok'] );
				} else {
					//unset( $options['tripadvisor'] ); 
				}







				// Select
				/*
				if ( ! empty( $options['select_example'] ) ) {
					$options['select_example'] = sanitize_text_field( $options['select_example'] );
				}
                */
			}

			// Return sanitized options
			return $options;

		}

		/**
		 * Settings page output
		 *
		 * @since 1.0.0
		 */
		public static function create_admin_page() { ?>

			<div class="wrap">
                <style>
                    .nav-content {display:none;}
                    .nav-content.active {display:block;}
                </style>
				<h1><?php esc_html_e( 'Theme Options', 'airtec' ); ?></h1>
				
				
                <?php
                $default_tab = null;
                $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;
                ?>
                
                
                <nav class="nav-tab-wrapper">
                  <a href="#" id="contact" class="nav-tab nav-tab nav-tab-active">Contact Info</a>
                  <a href="#" id="logo" class="nav-tab">Logo</a>
                  <a href="#" id="store" class="nav-tab">Workings Hours</a>
                  <a href="#" id="social" class="nav-tab">Social</a>
                  <!--<a href="#" id="advanced" class="nav-tab">Advanced</a>-->
                </nav>
                
                
                <form method="post" action="options.php">
                
                	<?php settings_fields( 'theme_options' ); ?>
                
                        <div class="tab-content">
                    
                            <div id="logo-content" class="nav-content"><?php show_logo_theme();?></div>
                            <div id="contact-content" class="nav-content active"><?php show_contact_informations();?></div>
                            <div id="store-content" class="nav-content"><?php show_store_informations();?></div>
                            <div id="social-content" class="nav-content"><?php show_social_tabs();?></div>
                            <div id="advanced-content" class="nav-content"><?php show_advanced_tabs();?></div>
                        
                        </div>
                    <?php submit_button(); ?>
                 </form>
                    <script>
                        jQuery( document ).ready(function($) {
                            $(".nav-tab").click(function() {
                               var id = $(this).attr('id');
                               $('.nav-tab').each(function() {
                                   $(this).removeClass('nav-tab-active');
                               });
                               $("#"+id).addClass('nav-tab-active');
                               $('.nav-content').each(function() {
                                   $(this).removeClass('active');
                               });
                               $("#"+id+"-content").addClass('active');
                            });
                        });
                    </script>
			</div><!-- .wrap -->
		<?php }

	}
}
new Custom_Theme_Options();

// Helper function to use in your theme to return a theme option value
function custom_get_theme_option( $id = '' ) {
	return Custom_Theme_Options::get_theme_option( $id );
}