<?php
if (ob_get_contents()) ob_clean();
ob_start();

function greeklish($str) {
  $greek = array('α','ά','Ά','Α','β','Β','γ','Γ','δ','Δ','ε','έ','Ε','Έ','ζ','Ζ','η','ή','Η','θ','Θ',
  'ι','ί','ϊ','ΐ','Ι','Ί','κ','Κ','λ','Λ','μ','Μ','ν','Ν','ξ','Ξ','ο','ό','Ο','Ό','π','Π','ρ','Ρ','σ',
  'ς','Σ','τ','Τ','υ','ύ','Υ','Ύ','φ','Φ','χ','Χ','ψ','Ψ','ω','ώ','Ω','Ώ',' ','&amp;','&',"'",'.','/');
  $english = array('a', 'a','a','a','b','b','g','g','d','d','e','e','e','e','z','z','i','i','i','th','th',
  'i','i','i','i','i','i','k','k','l','l','m','m','n','n','x','x','o','o','o','o','p','p' ,'r','r','s',
  's','s','t','t','u','u','y','y','f','f','x','x','ps','ps','o','o','o','o','-','-','-','','-','-');
  $string = strtolower(str_replace($greek, $english, strip_tags($str)));
  return $string;
}

function js_greeklish() {
    ?>
	<script>
	function greeklish(str) {
		  str  = str.replace(/^\s+|\s+$/g, '').toLowerCase();    
		  greek = ['α','ά','Ά','Α','β','Β','γ','Γ','δ','Δ','ε','έ','Ε','Έ','ζ','Ζ','η','ή','Η','θ','Θ',
		  'ι','ί','ϊ','ΐ','Ι','Ί','κ','Κ','λ','Λ','μ','Μ','ν','Ν','ξ','Ξ','ο','ό','Ο','Ό','π','Π','ρ','Ρ','σ',
		  'ς','Σ','τ','Τ','υ','ύ','Υ','Ύ','φ','Φ','χ','Χ','ψ','Ψ','ω','ώ','Ω','Ώ',' ','&amp;','&',"'",'.','/'];
		  english = ['a', 'a','a','a','b','b','g','g','d','d','e','e','e','e','z','z','i','i','i','th','th',
		  'i','i','i','i','i','i','k','k','l','l','m','m','n','n','x','x','o','o','o','o','p','p' ,'r','r','s',
		  's','s','t','t','u','u','y','y','f','f','x','x','ps','ps','o','o','o','o','-','-','-','','-','-'];

		  for ( var i = 0; i < greek.length; i++ ) {
			  while( str.indexOf( greek[i]) !== -1 ){
				  str = str.replace( greek[i], english[i] );
			  }
		  }
		  str = str.replace(/[^a-z0-9 -]/g, '').replace(/\s+/g, '-').replace(/-+/g, '-'); 
		  return str;
	}
	</script>
	<?php
}
add_action('admin_footer', 'js_greeklish');

add_action('admin_menu', 'sub_menu_redirections');
function sub_menu_redirections() {
    add_submenu_page('theme-settings','Redirects', 'Redirects', 'manage_options', 'custom-redirections', 'redirections_panel');
}
 
function redirections_panel() {
    if (!current_user_can('manage_options'))  {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }
    $langNo = 1;
    if (isset($_POST['menuitem_'.$langNo])) {
        $sanitized = array();
        foreach ( $_POST['menuitem_'.$langNo] as $key => $detail ) {
			$detail = str_replace("&","&amp;",$detail);
			$all_details = serialize($detail);
			$sanitized[$key] =  $all_details;
		}
		update_option('custom_redirection',$sanitized);
    } 
    ?>
    <div class="wrap">
        <h2>Redirects</h2>
    </div>
	<style>
		table{
			width: 100%;
			margin: 20px 0;
			border-collapse: collapse;
		}
		table, th, td{
			border: 1px solid #cdcdcd;
		}
		table th, table td{
			padding: 5px;
			text-align: left;
		}
		.strong {
			font-weight:bold;	
		}
		.cursordrag {
			cursor:	all-scroll;
		}
		.selectedRow, .selectedRow:active {
            background-color: #E7E7E7;
            cursor: move;
        }
		td {
			position: relative;
		}
		.delimg {
			font-size:30px;
			color:red;
			display:inline-block;
			position:absolute;
			top:0;
			right:3px;
			line-height: 0.6;
		}
		.centerd {
			text-align:center;	
		}
		#table_<?php echo $langNo;?> > thead > tr > th:nth-child(2),
		#table_<?php echo $langNo;?> > thead > tr > th:nth-last-child(3) {
			width:80px
		}
	</style>
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script>
		jQuery(document).ready(function($){
			
			
			$("#menu_item_<?php echo $langNo;?>").submit(function(e){
				e.preventDefault();
				var rowCount = $("#table_<?php echo $langNo;?> tbody tr").length;
				rowCount++;
				var name = $("#redirect_from_item_<?php echo $langNo;?>").val();
				var subtitle = $("#subtitle_of_item_<?php echo $langNo;?>").val();
				var info = $("#redirect_to_item_<?php echo $langNo;?>").val();
				var markup = "<tr data-pos='"+rowCount+"' class='menu-row'><td><input type='checkbox' name='record'><td><input style='width:100%' type='text' name='menuitem_<?php echo $langNo;?>[rf][]' value='" + name + "'></td><td><input style='width:100%' type='text' name='menuitem_<?php echo $langNo;?>[rt][]' value='"+info+"'></td></tr>";
				$("table#table_<?php echo $langNo;?> tbody").append(markup);
				$("#redirect_from_item_<?php echo $langNo;?>").val("");
				$("#redirect_to_item_<?php echo $langNo;?>").val("");
			});
			
			// Find and remove selected table rows
			$(".delete-row_<?php echo $langNo;?>").click(function(e){
				e.preventDefault();
				$("table tbody").find('input[name="record"]').each(function(){
					if($(this).is(":checked")){
						$(this).parents("tr").remove();
					}
				});
			});
		});    
	</script>
    <form id="menu_item_<?php echo $langNo;?>">
        <p><input type="text" id="redirect_from_item_<?php echo $langNo;?>" placeholder="Redirct From - COPY PASTE FROM BROWSER" style="width:80%"></p>
        <p><input type="text" id="redirect_to_item_<?php echo $langNo;?>" placeholder="Redirct To"  style="width:80%"></p>
        <p><input type="submit" class="add_menu_item_row_<?php echo $langNo;?> button button-medium" value="Add Redirect"><br></p>
    </form><br>
    <form action="" method="POST">
    <table id="table_<?php echo $langNo;?>">
        <thead>
            <tr>
                <th style="width:20px"></th>
                <th style="width:50%">Redirect From - COPY PASTE FROM BROWSER</th>
                <th style="width:47%">Redirect To</th>
            </tr>
        </thead>
        <tbody class="connectedSortable">
			<?php
			$saved = get_option('custom_redirection', true );
        	$data_saved = array();
        	foreach ($saved as $key=>$value)
        	{
        		$data_saved[$key] = unserialize((string)$value);
        	}
			if (!empty($data_saved)) {
    			for ($x=0;$x<count($data_saved['rf']);$x++) {
    				$rf = $data_saved['rf'][$x];
    				$rt = $data_saved['rt'][$x];
    				$class=" class='menu-row'"; 
    				$name_type="text";
    				if (!empty($rt)) {
    				?>
    				<tr data-pos='<?php echo $x;?>' <?php echo $class;?>>
    				   <td><input type='checkbox' name='record'></td>
    				   <td>
    				       <?php if (strpos($rf, '%') !== false) echo urldecode($rf).'<br>';?>
    				       <input style='width:100%' type='<?php echo $name_type;?>' name='menuitem_<?php echo $langNo;?>[rf][]' value='<?php echo $rf;?>'>
    				    </td>
    				   <td>
    				       <?php if (strpos($rt, '%') !== false) echo urldecode($rt).'<br>';?>
    				       <input style='width:100%' type='<?php echo $name_type;?>' name='menuitem_<?php echo $langNo;?>[rt][]' value='<?php echo $rt;?>'>
    				    </td>
    				</tr>
    			    <?php
    				}
    			}
			}
			?>
        </tbody>
    </table>
    <p>Check the rows you want to delete and press button</p>
    <button type="button" class="delete-row_<?php echo $langNo;?> button button-medium">Delete Rows</button>&nbsp;&nbsp;&nbsp;&nbsp;
    <br><br>
    <button type="submit" class="button button-primary">Save Changes</button>
    <p>*Maybe needs <strong>Clear Cache</strong> after submit your redirects</p>
    </form>
    <?php
}



function redirect_complete() {
    
	$saved = get_option('custom_redirection', true );
    $data_saved = array();

    if (!empty($saved) && ($saved!='1')) {
        foreach ($saved as $key=>$value)
        {
        	$data_saved[$key] = unserialize((string)$value);
        }
    }
	if (!empty($data_saved)) {
    	for ($x=0;$x<count($data_saved['rf']);$x++) {
    		$redirect_from = $data_saved['rf'][$x];
    		$redirect_to = $data_saved['rt'][$x];
    		$rfrom = rtrim($redirect_from, '/');
    		$rto = rtrim($redirect_to, '/');
    		$rf = str_replace(get_home_url(),'',$rfrom);
    		$rt = str_replace(get_home_url(),'',$rto);
    		custom_redirection($rf,$rt);
    	}
	}
}
add_action( 'init', 'redirect_complete' );


if (!is_user_logged_in()) {
    $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    
    if (strpos($actual_link, 'admin-ajax.php') === false) {
        custom_redirection('wp-admin','404');
    }
    if (isset($_GET['action']) && $_GET['action']!='postpass') {
        custom_redirection('wp-login.php','404t4');
    }
} else {
    custom_redirection('wp-login.php','inklogin.php');
}

function lostpassword_inklogin($lostpassword_url, $redirect ) {
    $lost_pass = get_home_url().'/inklogin.php?action=lostpassword';
    return $lost_pass;
}
add_filter('lostpassword_url', 'lostpassword_inklogin', 10, 2);


function inklogin_retrieve_password_message( $message, $key, $user_login ) {

    $new_message = str_replace('wp-login.php', 'inklogin.php', $message);

	return $new_message;
}

add_filter( 'retrieve_password_message', 'inklogin_retrieve_password_message', 20, 3 );


function custom_redirection($old_path, $new_path) { 
    
    $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    
    $redirect = str_replace($old_path,$new_path,$actual_link);
    
    if ((strpos($actual_link, $old_path) !== false) && (strpos($actual_link, $new_path) === false)) {
        
    
        wp_redirect( $redirect, 301 ); 
        exit();
    }
}

// Disable access to author page
add_action('template_redirect', 'disable_author_page');

function disable_author_page() {
    global $wp_query;

    if ( is_author() ) {
        $wp_query->set_404();
        status_header(404);
        // Redirect to homepage
        wp_redirect(get_option('home'));
    }
}





add_filter('login_errors', function($a) { return null; }); 
/* Hide WP version strings from scripts and styles
* @return {string} $src
* @filter script_loader_src
* @filter style_loader_src
*/
/*
function remove_wp_version_strings( $src ) {
    global $wp_version;
    parse_str(parse_url($src, PHP_URL_QUERY), $query);
    if ( !empty($query['ver']) && $query['ver'] === $wp_version ) {
        $src = remove_query_arg('ver', $src);
    }
    return $src;
}
add_filter( 'script_loader_src', 'remove_wp_version_strings' );
add_filter( 'style_loader_src', 'remove_wp_version_strings' );

*/
/* Hide WP version strings from generator meta tag */
function remove_metatag_version() {
    return '';
}

add_filter('the_generator', 'remove_metatag_version');
remove_action('wp_head','wp_generator');



add_filter( 'login_url', 'inklogin_url', PHP_INT_MAX );
function inklogin_url( $login_url ) {
	$login_url = site_url( 'inklogin.php', 'login' );	
    return $login_url;
}

add_filter( 'logout_url', 'my_logout_page', 10, 2 );
function my_logout_page( $logout_url) {
    return site_url( 'inklogin.php');  
}



function inklogin_custom_password_form() {
	global $post;

	$loginurl = site_url() . '/inklogin.php?action=postpass';
	$label = 'pwbox-' . ( ! empty( $post->ID ) ? $post->ID : rand() );

	ob_start();
	?>

	<style>
        form.post-password-form {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            background: white;
            z-index: 99999999;
        }
        form.post-password-form > p {
            color: white;
        }
        form.post-password-form label {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%,-50%);
            width: 100%;
            max-width: 400px;
            padding: 20px;
            margin-top: -50px;
        }
        form.post-password-form input[type="submit"] {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 10px 20px;
            margin-top: 50px;
        }
	</style>
	<div class="container-custom">			
		<form action="<?php echo esc_attr( $loginurl ) ?>" method="post" class="post-password-form">
			<label for="<?php echo esc_attr( $label ) ?>" class="post-password-label"><?php _e( "Password:" ) ?>
			<input name="post_password" id="<?php echo esc_attr( $label ) ?>" class="input post-password-class" type="password" />
			</label>
			<input type="submit" name="Submit" value="<?php esc_attr_e( 'Log in' ) ?>" />			
		</form>
	</div>

	<?php
	return ob_get_clean();
}	
add_filter( 'the_password_form', 'inklogin_custom_password_form', 9999 );
?>
