<?php


/*********
 * 
 * SLIDER POST TYPE
 * 
*********/
function custom_post_type_sliders() {
	$labels = array(
		'name'                => __( 'Sliders' ),
		'singular_name'       => __( 'Slider'),
		'menu_name'           => __( 'Sliders'),
		'parent_item_colon'   => __( 'Parent'),
		'all_items'           => __( 'All Sliders'),
		'view_item'           => __( 'View Slider'),
		'add_new_item'        => __( 'Add new Slider'),
		'add_new'             => __( 'Add new'),
		'edit_item'           => __( 'Edit Slider'),
		'update_item'         => __( 'Update Slider'),
		'search_items'        => __( 'Search Slider'),
		'not_found'           => __( 'Not found'),
		'not_found_in_trash'  => __( 'Not found in trash')
	);
	$args = array(
		'label'               => __( 'slider'),
		'description'         => __( 'Sliders'),
		'labels'              => $labels,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'page-attributes'),
		'public'              => true,
		'hierarchical'        => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => false,
		'show_in_admin_bar'   => false,
		'has_archive'         => false,
		'can_export'          => true,
		'exclude_from_search' => true,
	    'yarpp_support'       => false,
		'publicly_queryable'  => false,
		'menu_icon'           => 'dashicons-images-alt',
		'capability_type'     => 'page',
);
	register_post_type( 'slider', $args );
}
add_action( 'init', 'custom_post_type_sliders', 0 );







/*********
 * 
 * SLIDER CATEGORIES
 * 
*********/


add_action( 'init', 'slider_categories', 0 );
function slider_categories() {
 
  $labels = array(
    'name' => _x( 'Categories', 'taxonomy general name' ),
    'singular_name' => _x( 'Category', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Category' ),
    'all_items' => __( 'All Categories' ),
    'edit_item' => __( 'Edit Category' ), 
    'update_item' => __( 'Update Category' ),
    'add_new_item' => __( 'Add new Category' ),
    'new_item_name' => __( 'New Category' ),
    'menu_name' => __( 'Categories' ),
  ); 	
 
  register_taxonomy('slider_category',array('slider'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'public' =>  false,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => false,
    'rewrite' => false
  ));
}





/*********
 * 
 * SLIDER META BOXES
 * 
*********/


function url_mobile_content() {
   add_meta_box(
       'url_mobile_content',       
       'Mobile Content ',                  
       'show_mobile_content',  
       'slider',                 
       'normal',                  
       'high'                   
   );
}
//add_action('add_meta_boxes', 'url_mobile_content');

function show_mobile_content($post) {
    $mobile_content = get_post_meta($post->ID,'mobile_content',true);
    wp_editor( $mobile_content,  'mobile_content', array('media' => true) );
}

function url_slider() {
   add_meta_box(
       'url_slider',       
       'URL',                  
       'show_url_slider',  
       'slider',                 
       'normal',                  
       'high'                     
   );
}
add_action('add_meta_boxes', 'url_slider');
function show_url_slider($post) {

    $url_slider = get_post_meta($post->ID,'url_slider',true);
    $url_text = get_post_meta($post->ID,'url_text',true);
    ?>

    <!-- my custom value input -->
    <div style="display:flex">
        <label>URL Link
            <input type="text" name="url_slider" value="<?php echo $url_slider;?>" style="width:100%">
        </label>
    </div><br><br>
    <div style="display:flex">
        <label>BUTTON text
            <input type="text" name="url_text" value="<?php echo $url_text;?>" style="width:100%">
        </label>
    </div><br>
    
    <?php
}

 function slider_save($post_id) {
        
    if( isset( $_POST['slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['url_slider'];
                update_post_meta($post_id, 'url_slider', $data);
        
                $data = $_POST['url_text'];
                update_post_meta($post_id, 'url_text', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save');








function page_info_top_slide() {
   add_meta_box(
       'room_info_top_slide',       
       'Top Slider Category',                  
       'show_page_top_slider',  
       array('page','post','super-markets'),                 
       'side',                  
       'high'                     
   );
}
add_action('add_meta_boxes', 'page_info_top_slide');



function show_page_top_slider($post) {
    global $wpdb;
    
    wp_nonce_field( 'top_slider_nonce', 'top_slider_nonce' );
    $top_slider = get_post_meta($post->ID,'top_slider_category_id',true);
    
    $slider_categories = get_terms( array(
        'taxonomy' => 'slider_category',
        'hide_empty' => false,
    ) );
    
    echo '<select name="top_slider_category_id">';
     echo '<option value=""></option>';
    foreach ($slider_categories as $slider_categopry) {
        if ($slider_categopry->term_id == $top_slider) $active = ' selected '; else  $active ='';
        echo '<option value="'.$slider_categopry->term_id.'" '.$active.'>'.$slider_categopry->name.'</option>';
    }
    echo '</select>';
}


 function save_page_top_slider($post_id) {
     if( ! isset($_POST['top_slider_nonce']) ) {
            return;
        } 
        
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        } 


        if ( ! wp_verify_nonce ( $_POST['top_slider_nonce'], 'top_slider_nonce' ) ) { 
            return;
        } 

        // Making sure the user has permission
        if( 'page' == $_POST['post_type'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
		
        if( ! isset($_POST['top_slider_category_id']) ) {
            return;
        } 
		
        $data_slider = $_POST['top_slider_category_id'];
        update_post_meta($post_id, 'top_slider_category_id', $data_slider);
		
 }
 
add_action('save_post_page', 'save_page_top_slider');
add_action('save_post_ppst', 'save_page_top_slider');
add_action('save_post_super-markets', 'save_page_top_slider');








function import_slider($atts, $content = null){
	$var = shortcode_atts( array(
		'slide_cat' => '',
		'slide_class' => '',
	), $atts );
	
	$class = $var['slide_class'];
	
    $args = array(
        'post_type' => 'slider',
        'post_status' => 'publish',
        'orderby' => 'menu_order',
        'posts_per_page' => -1,
        'order' => 'ASC',
        'tax_query' => array(
            array(
                'taxonomy' => 'slider_category',
                'field'    => 'term_id',
                'terms'    => $var['slide_cat']
            )
        )
    );
    $query = new WP_Query( $args );
    $return = '';
    if ($query->have_posts()) {
        $claIframe_slider = '';
        while ( $query->have_posts() ) {
            $query->the_post();
            $post_id = get_the_ID();
            $iframe_slider = get_post_meta($post_id,'iframe_slider', true);
            if (!empty($iframe_slider)) $claIframe_slider = ' slider-with-iframe'; 
        }
        $return .= '<div id="sc-'.$var["slide_cat"].'" class="thumbnail-of-port-top slider-list '.$claIframe_slider.'">';
        while ( $query->have_posts() ) {
            $query->the_post();
            $post_id = get_the_ID();
            $img_url = get_the_post_thumbnail_url($post_id, 'full');
            $conte = get_the_content();
            $til = get_the_title();
            $url = get_post_meta($post_id,'url_slider', true);
            $button = get_post_meta($post_id,'url_text', true);
            $iframe_slider = get_post_meta($post_id,'iframe_slider', true);
            $mp4_slider = get_post_meta($post_id,'mp4_slider', true);
            $mp4_mobile_slider = get_post_meta($post_id,'mp4_mobile_slider', true);
            $webm_slider = get_post_meta($post_id,'webm_slider', true);
            $mobile_content = get_post_meta($post_id,'mobile_content', true);
            $mobile_img = '';
            $one_top = get_post_meta($post_id,'thumb_mobile', true);
            if ($one_top > 0) {
                $one_img = wp_get_attachment_image_src($one_top,'full');
                $mobile_img = $one_img[0];
            }
            if (!empty($iframe_slider)) $claIframe = ' this-slide-has-iframe'; else $claIframe = '';
            $button = get_post_meta($post_id,'url_text', true);
            if (empty($button)) $button = 'DISCOVER MORE';
            $return .= '<div id="slidec-'.$post_id.'" class="slider-list-item '.$claIframe.'">';
		        if (!empty($iframe_slider)) {
		            $return .=  '<div class="iframeSlider iframeVideo" style="background-image:url(\''.$img_url.'\');background-size:cover;background-position:center;">';
		            $return .= $iframe_slider;
		            
        		    
		            $return .= '</div>';
            		        if ((!empty($conte)))  $return .=  '<div class="slideLayer"><div class="contentSlider with-iframe">';
                				//if (!empty($til)) $return .= '<h3 class="slide-title '.$class.'">'.$til.'</h3>';
                				if (!empty($conte)) $return .= '<div class="slide-desc keg '.$class.'">'.wpautop($conte).'</div>';
                				if (!empty($url)) $return .= '<div class="slide-href"><button><a href="'.$url.'" class="keg wp-block-button__link">'.$button.'</a></button></div>';
                			if ((!empty($til)) || (!empty($conte)) || (!empty($url)))  $return .= '</div></div>';
		        } else if (empty($mp4_slider)) {
                    if (!empty($conte)) $classCon=" has-conte"; else $classCon = "";
        		    $return .= '<div class="bgslide'.$classCon.'" style="background-image:url('.$img_url.')">';
        		    if (!empty($mobile_img)) {
        		        $id_rand = 'parallax-id-'.rand(100,999);
            		    $return .= '<div class="parallax-img-slide" id="'.$id_rand.'"><img src="'.$mobile_img.'" alt="parallax"></div>';
            		    $return .= '<script>window.addEventListener("scroll", (event) => {
                                let scroll = this.scrollY;
                                document.getElementById("'.$id_rand.'").style.transform = "translateY("+scroll+"px)";

                            });</script>';
        		    }
        		    if (!empty($img_url)) {
        		            $return .=  '<div class="mobile-image-with-iframe" style="display:none"><img src="'.$img_url.'" alt="slider"></div>';
            		        if (!empty($conte)) {
            		            $return .=  '<div class="slideLayer"><div class="contentSlider">';
            		             $return .= '<div class="slide-desc keg '.$class.'">'.wpautop($conte).'</div>';
            		        }
            		        else if ((!empty($til)) || (!empty($conte)) || (!empty($url))) { 
            		            $return .=  '<div class="slideLayer"><div class="contentSlider no-opacity">';
                				if (!empty($til)) $return .= '<h3 class="slide-title '.$class.'">'.$til.'</h3>';
                				if (!empty($conte)) $return .= '<div class="slide-desc keg '.$class.'">'.wpautop($conte).'</div>';
            		        }
                			if (!empty($url)) $return .= '<div class="slide-href"><button><a href="'.$url.'" class="keg wp-block-button__link">'.$button.'</a></button></div>';
                			if ((!empty($til)) || (!empty($conte)) || (!empty($url)))  $return .= '</div></div>';
        		    }
    	            $return .=  '</div>';
    	        } else {
                     $return .=  '<div class="homeSlider homeVideo">
                                <video loop playsinline="" muted="" poster="'.$img_url.'" type="video/mp4" class="home-video" id="home-video-'.$post_id.'">
                                    <source src="'.$mp4_slider.'" type="video/mp4">  
                                </video>
                                <div class="mutevideo">
                                    <span class="dashicons dashicons-controls-volumeon mute-video"  style="display:none"></span>
                                    <span class="dashicons dashicons-controls-volumeoff mute-video"></span>
                                </div>
                                <script>
                                $( document ).ready(function() {
                                    $(".mute-video").click(function () {
                                        if ($("video").prop("muted")) {
                                            $("video").prop("muted", false);
                                            $(".dashicons-controls-volumeoff").hide(); 
                                            $(".dashicons-controls-volumeon").show(); 
                                        } else {
                                            $("video").prop("muted", true);
                                            $(".dashicons-controls-volumeon").hide(); 
                                            $(".dashicons-controls-volumeoff").show(); 
                                        }
                                    });
                                
                    		        if (($(window).width() < 641) && ($(window).height() > $(window).width())) {
                    		            $("#home-video-'.$post_id.' source").attr("src","'.$mp4_mobile_slider.'");
                    		            $("#home-video-'.$post_id.'")[0].load();
                    		        }
                                    const videoElement = document.getElementById("home-video-'.$post_id.'");
                                    if (videoElement.playing) {
                                        // video is already playing so do nothing
                                        $("#loading").hide();
                                    }
                                    else {
                                        // video is not playing
                                        // so play video now
                                        videoElement.play();
                                        $("#loading").hide();
                                    }
                                     videoElement.onended = function(e) {
                                        $(".mutevideo").hide();
                                    };
                                });
                                </script>
                            </div>';
        	    }
    	    $return .=  '</div>';
        }
        wp_reset_postdata();
        $return .=  '</div>';
    }
    return $return; 
}           
add_shortcode('import_slider', 'import_slider');

function arrows_down() {
    $return .=  '<svg version="1.1" id="arrows_down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 63.1 43.9" style="enable-background:new 0 0 63.1 43.9;" xml:space="preserve"> <path d="M31.6,43.9l31.6-31.6H0L31.6,43.9z M31.6,42.5L2.4,13.4h58.3L31.6,42.5z"/> <g> <path d="M31.6,31.6L63.1,0H0L31.6,31.6z M31.6,30.1L2.4,1h58.3L31.6,30.1z"/> </g> </svg>';
    $return .=  '<svg version="1.1" id="arrows_down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 63.1 43.9" style="enable-background:new 0 0 63.1 43.9;" xml:space="preserve"> <path d="M31.6,43.9l31.6-31.6H0L31.6,43.9z M31.6,42.5L2.4,13.4h58.3L31.6,42.5z"/> <g> <path d="M31.6,31.6L63.1,0H0L31.6,31.6z M31.6,30.1L2.4,1h58.3L31.6,30.1z"/> </g> </svg>';
    //$return =  '<svg version="1.1" id="arrows_down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.5 44.8" style="enable-background:new 0 0 66.5 44.8;" xml:space="preserve"> <style type="text/css"> .polygonarrow{fill:none;stroke:#000000;stroke-miterlimit:10;} </style> <polygon class="polygonarrow" points="33.3,43.8 64.9,12.2 1.7,12.2 "/> <polygon class="polygonarrow" points="33.3,32.5 64.9,0.9 1.7,0.9 "/> </svg>';
    return $return; 
}           
add_shortcode('arrows_down', 'arrows_down');

function thumb_mobile_img_meta_box() {
	add_meta_box( 
		'thumb_mobile_img_meta_box', 
		__( 'Parallax image', 'domain.com' ), 
		'thumb_mobile_img_metabox', 
		'slider', 
		'side', 
		'low'
	);
}
add_action('add_meta_boxes', 'thumb_mobile_img_meta_box');

function miravo_arrow() {
    return '<svg id="aHrefArrow" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 36.3 38" style="enable-background:new 0 0 36.3 38;" xml:space="preserve"> <style type="text/css"> .st0{fill-rule:evenodd;clip-rule:evenodd;fill:#333333;} .st1{fill-rule:evenodd;clip-rule:evenodd;fill:none;stroke:#333333;stroke-width:0.75;stroke-miterlimit:10;} .st2{fill-rule:evenodd;clip-rule:evenodd;fill:none;stroke:#333333;stroke-width:0.5;stroke-miterlimit:10;} </style> <g id="Layer_1"> </g> <g id="Layer_3"> <path class="st0" d="M19.3,19.2l-7-7c-0.1-0.1-0.2-0.1-0.3,0l-0.3,0.3l6.5,6.5H0.9v0.6h17.3l-6.5,6.5l0.3,0.3 c0.1,0.1,0.2,0.1,0.3,0l7-7C19.3,19.4,19.3,19.3,19.3,19.2z"></path> <path class="st1" d="M3.3,9.2c3.2-4.5,8.4-7.4,14.3-7.4c9.7,0,17.6,7.8,17.6,17.5c0,9.7-7.9,17.5-17.6,17.5c-6.4,0-12-3.4-15.1-8.6 "></path> <path class="st2" d="M3.3,9.2"></path> <path class="st2" d="M2.5,28.3"></path> </g> </svg>';
}
add_shortcode('miravo_arrow','miravo_arrow');

function thumb_mobile_img_metabox ( $post ) {
	global $content_width, $_wp_additional_image_sizes;
    
     wp_nonce_field( 'mobile_thumb_cover_image_nonce', 'mobile_thumb_cover_image_nonce' );
	$image_id = get_post_meta( $post->ID, 'thumb_mobile', true );

	$old_content_width = $content_width;
	$content_width = 254;

	if ( $image_id && get_post( $image_id ) ) {

		if ( ! isset( $_wp_additional_image_sizes['post-thumbnail'] ) ) {
			$thumbnail_html = wp_get_attachment_image( $image_id, array( $content_width, $content_width ) );
		} else {
			$thumbnail_html = wp_get_attachment_image( $image_id, 'post-thumbnail' );
		}

		if ( ! empty( $thumbnail_html ) ) {
			$content = $thumbnail_html;
			$content .= '<p class="hide-if-no-js"><a href="javascript:;" id="remove_thumb_mobile_img_button" >' . esc_html__( 'Remove Parallax image', 'domain.com' ) . '</a></p>';
			$content .= '<input type="hidden" id="upload_thumb_mobile_img" name="_mobile_image_cover_image" value="' . esc_attr( $image_id ) . '" />';
		}

		$content_width = $old_content_width;
	} else {

		$content = '<img src="" style="width:' . esc_attr( $content_width ) . 'px;height:auto;border:0;display:none;" />';
		$content .= '<p class="hide-if-no-js"><a title="' . esc_attr__( 'Set Parallax image', 'domain.com' ) . '" href="javascript:;" id="upload_thumb_mobile_img_button" id="set-one_top-image" data-uploader_title="' . esc_attr__( 'Choose an image', 'domain.com' ) . '" data-uploader_button_text="' . esc_attr__( 'Set Parallax image', 'domain.com' ) . '">' . esc_html__( 'Set Parallax image', 'domain.com' ) . '</a></p>';
		$content .= '<input type="hidden" id="upload_thumb_mobile_img" name="_mobile_image_cover_image" value="" />';

	}

	echo $content;
}


add_action( 'save_post', 'thumb_mobile_img_save', 10, 1 );
function thumb_mobile_img_save ( $post_id ) {
    
        if( ! isset($_POST['mobile_thumb_cover_image_nonce']) ) {
            return;
        } 
        
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        } 


        if ( ! wp_verify_nonce ( $_POST['mobile_thumb_cover_image_nonce'], 'mobile_thumb_cover_image_nonce' ) ) { 
            return;
        } 

		
        if( ! isset($_POST['_mobile_image_cover_image']) ) {
            return;
        } 
     
     
     
    	if( isset( $_POST['_mobile_image_cover_image'] ) ) {
    		$image_id = (int) $_POST['_mobile_image_cover_image'];
    		update_post_meta( $post_id, 'thumb_mobile', $image_id );
    	}
}



add_action('admin_footer', 'init_thumb_mobile_img');

function init_thumb_mobile_img() {
    ?>
        <script>
        jQuery(document).ready(function($) {
        
        	// Uploading files
        	var file_frame;
        
        	jQuery.fn.upload_thumb_mobile_img = function( button ) {
        	    
        		var button_id = button.attr('id');
        		var field_id = button_id.replace( '_button', '' );
        
        		// If the media frame already exists, reopen it.
        		if ( file_frame ) {
        		  file_frame.open();
        		  return;
        		}
        
        		// Create the media frame.
        		file_frame = wp.media.frames.file_frame = wp.media({
        		  title: jQuery( this ).data( 'uploader_title' ),
        		  button: {
        		    text: jQuery( this ).data( 'uploader_button_text' ),
        		  },
        		  multiple: false
        		});
        
        		// When an image is selected, run a callback.
        		file_frame.on( 'select', function() {
        		  var attachment = file_frame.state().get('selection').first().toJSON();
        		  jQuery("#"+field_id).val(attachment.id);
        		  jQuery("#thumb_mobile_img_meta_box img").attr('src',attachment.url);
        		  jQuery( '#thumb_mobile_img_meta_box img' ).show();
        		  jQuery( '#' + button_id ).attr( 'id', 'remove_thumb_mobile_img_button' );
        		  jQuery( '#remove_thumb_mobile_img_button' ).text( 'Remove Parallax image' );
        		});
        
        		// Finally, open the modal
        		file_frame.open();
        	};
        
        	jQuery('#thumb_mobile_img_meta_box').on( 'click', '#upload_thumb_mobile_img_button', function( event ) {
        		event.preventDefault();
        		jQuery.fn.upload_thumb_mobile_img( jQuery(this) );
        	});
        
        	jQuery('#thumb_mobile_img_meta_box').on( 'click', '#remove_thumb_mobile_img_button', function( event ) {
        		event.preventDefault();
        		jQuery( '#upload_thumb_mobile_img' ).val( '' );
        		jQuery( '#thumb_mobile_img_meta_box img' ).attr( 'src', '' );
        		jQuery( '#thumb_mobile_img_meta_box img' ).hide();
        		jQuery( this ).attr( 'id', 'upload_thumb_mobile_img_button' );
        		jQuery( '#upload_thumb_mobile_img_button' ).text( 'Set Parallax image' );
        	});
        
        });
        </script>
    <?php 
}






function mp4_slider() {
   add_meta_box(
       'mp4_slider',       
       'MP4 Video',                  
       'show_mp4_slider',  
       'slider',                 
       'normal'                     
   );
}
add_action('add_meta_boxes', 'mp4_slider');
function show_mp4_slider($post) {
    wp_nonce_field( 'mp4_slider_nonce', 'mp4_slider_nonce' );

    $mp4_slider = get_post_meta($post->ID,'mp4_slider',true);
    ?>

    <div style="display:flex">
        <input type="text" name="mp4_slider" id="mp4_slider_video" value="<?php echo $mp4_slider;?>" style="width:100%">
        <button id="upload_mp4" class="button button-medium">Upload MP4</button>
        <button id="remove_mp4" class="button button-medium">REMOVE MP4</button>
    </div><br>
    
        <script>
      jQuery(document).ready(function($){

        // Instantiates the variable that holds the media library frame.
        var meta_image_frame;


        // Runs when the image button is clicked.
        $('#upload_mp4').click(function(e){

            // Prevents the default action from occuring.
            e.preventDefault();

            // If the frame already exists, re-open it.
            if ( meta_image_frame ) {
                meta_image_frame.open();
                return;
            }

            // Sets up the media library frame
            meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
                title: "Slider Video",
                button: { text:  "Use this video" },
                library: { type: 'video' }
            });

            // Runs when an image is selected.
            meta_image_frame.on('select', function(){

                // Grabs the attachment selection and creates a JSON representation of the model.
                var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

                // Sends the attachment URL to our custom image input field.
                $('#mp4_slider_video').val(media_attachment.url);

            });

            // Opens the media library frame.
            meta_image_frame.open();

        });
        $('#remove_mp4').click(function(e){
            e.preventDefault();
                $('#mp4_slider_video').val("");
        });



    });
        </script>
      
    
    <?php
}
 function slider_save_mp4($post_id) {
        
    if( isset( $_POST['mp4_slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['mp4_slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['mp4_slider'];
                update_post_meta($post_id, 'mp4_slider', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save_mp4');











function webm_slider() {
   add_meta_box(
       'webm_slider',       
       'WEBM Video',                  
       'show_webm_slider',  
       'slider',                 
       'normal'                     
   );
}
add_action('add_meta_boxes', 'webm_slider');
function show_webm_slider($post) {
    wp_nonce_field( 'webm_slider_nonce', 'webm_slider_nonce' );

    $webm_slider = get_post_meta($post->ID,'webm_slider',true);
    ?>

    <div style="display:flex">
        <input type="text" name="webm_slider" id="webm_slider_video" value="<?php echo $webm_slider;?>" style="width:100%">
        <button id="upload_webm" class="button button-medium">Upload WEBM</button>
        <button id="remove_webm" class="button button-medium">REMOVE WEBM</button>
    </div><br>
    
        <script>
      jQuery(document).ready(function($){

        // Instantiates the variable that holds the media library frame.
        var meta_image_frame;


        // Runs when the image button is clicked.
        $('#upload_webm').click(function(e){

            // Prevents the default action from occuring.
            e.preventDefault();

            // If the frame already exists, re-open it.
            if ( meta_image_frame ) {
                meta_image_frame.open();
                return;
            }

            // Sets up the media library frame
            meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
                title: "Slider Video",
                button: { text:  "Use this video" },
                library: { type: 'video' }
            });

            // Runs when an image is selected.
            meta_image_frame.on('select', function(){

                // Grabs the attachment selection and creates a JSON representation of the model.
                var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

                // Sends the attachment URL to our custom image input field.
                $('#webm_slider_video').val(media_attachment.url);

            });

            // Opens the media library frame.
            meta_image_frame.open();

        });
        $('#remove_webm').click(function(e){
            e.preventDefault();
                $('#webm_slider_video').val("");
        });



    });
        </script>
      
    
    <?php
}
 function slider_save_webm($post_id) {
        
    if( isset( $_POST['webm_slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['webm_slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['webm_slider'];
                update_post_meta($post_id, 'webm_slider', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save_webm');












function mp4_mobile_slider() {
   add_meta_box(
       'mp4_mobile_slider',       
       'MP4 Video - MOBILE',                  
       'show_mp4_mobile_slider',  
       'slider',                 
       'normal'                     
   );
}
add_action('add_meta_boxes', 'mp4_mobile_slider');
function show_mp4_mobile_slider($post) {
    wp_nonce_field( 'mp4_mobile_slider_nonce', 'mp4_mobile_slider_nonce' );

    $mp4_mobile_slider = get_post_meta($post->ID,'mp4_mobile_slider',true);
    ?>

    <div style="display:flex">
        <input type="text" name="mp4_mobile_slider" id="mp4_mobile_slider_video" value="<?php echo $mp4_mobile_slider;?>" style="width:100%">
        <button id="upload_mp4_mobile" class="button button-medium">Upload MP4</button>
        <button id="remove_mp4_mobile" class="button button-medium">REMOVE MP4</button>
    </div><br>
    
        <script>
      jQuery(document).ready(function($){

        // Instantiates the variable that holds the media library frame.
        var meta_image_frame;


        // Runs when the image button is clicked.
        $('#upload_mp4_mobile').click(function(e){

            // Prevents the default action from occuring.
            e.preventDefault();

            // If the frame already exists, re-open it.
            if ( meta_image_frame ) {
                meta_image_frame.open();
                return;
            }

            // Sets up the media library frame
            meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
                title: "Slider Video",
                button: { text:  "Use this video" },
                library: { type: 'video' }
            });

            // Runs when an image is selected.
            meta_image_frame.on('select', function(){

                // Grabs the attachment selection and creates a JSON representation of the model.
                var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

                // Sends the attachment URL to our custom image input field.
                $('#mp4_mobile_slider_video').val(media_attachment.url);

            });

            // Opens the media library frame.
            meta_image_frame.open();

        });
        $('#remove_mp4_mobile').click(function(e){
            e.preventDefault();
                $('#mp4_mobile_slider_video').val("");
        });



    });
        </script>
      
    
    <?php
}
 function slider_save_mp4_mobile($post_id) {
        
    if( isset( $_POST['mp4_mobile_slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['mp4_mobile_slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['mp4_mobile_slider'];
                update_post_meta($post_id, 'mp4_mobile_slider', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save_mp4_mobile');









function webm_mobile_slider() {
   add_meta_box(
       'webm_mobile_slider',       
       'WEBM Video Mobile',                  
       'show_webm_mobile_slider',  
       'slider',                 
       'normal'                     
   );
}
add_action('add_meta_boxes', 'webm_mobile_slider');
function show_webm_mobile_slider($post) {
    wp_nonce_field( 'webm_mobile_slider_nonce', 'webm_mobile_slider_nonce' );

    $webm_mobile_slider = get_post_meta($post->ID,'webm_mobile_slider',true);
    ?>

    <div style="display:flex">
        <input type="text" name="webm_mobile_slider" id="webm_mobile_slider_video" value="<?php echo $webm_mobile_slider;?>" style="width:100%">
        <button id="upload_webm_mobile" class="button button-medium">Upload WEBM</button>
        <button id="remove_webm_mobile" class="button button-medium">REMOVE WEBM</button>
    </div><br>
    
        <script>
      jQuery(document).ready(function($){

        // Instantiates the variable that holds the media library frame.
        var meta_image_frame;


        // Runs when the image button is clicked.
        $('#upload_webm_mobile').click(function(e){

            // Prevents the default action from occuring.
            e.preventDefault();

            // If the frame already exists, re-open it.
            if ( meta_image_frame ) {
                meta_image_frame.open();
                return;
            }

            // Sets up the media library frame
            meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
                title: "Slider Video",
                button: { text:  "Use this video" },
                library: { type: 'video' }
            });

            // Runs when an image is selected.
            meta_image_frame.on('select', function(){

                // Grabs the attachment selection and creates a JSON representation of the model.
                var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

                // Sends the attachment URL to our custom image input field.
                $('#webm_mobile_slider_video').val(media_attachment.url);

            });

            // Opens the media library frame.
            meta_image_frame.open();

        });
        $('#remove_webm_mobile').click(function(e){
            e.preventDefault();
                $('#webm_mobile_slider_video').val("");
        });



    });
        </script>
      
    
    <?php
}
 function slider_save_webm_mobile($post_id) {
        
    if( isset( $_POST['webm_mobile_slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['webm_mobile_slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['webm_mobile_slider'];
                update_post_meta($post_id, 'webm_mobile_slider', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save_webm_mobile');









function iframe_slider() {
   add_meta_box(
       'iframe_slider',       
       'Iframe Video',                  
       'show_iframe_slider',  
       'slider',                 
       'normal'                     
   );
}
add_action('add_meta_boxes', 'iframe_slider');
function show_iframe_slider($post) {
    wp_nonce_field( 'iframe_slider_nonce', 'iframe_slider_nonce' );

    $iframe_slider = get_post_meta($post->ID,'iframe_slider',true);
    ?>
    <p>YouTube iframe => <strong>?autoplay=1&mute=1&enablejsapi=1&modestbranding=1&autohide=1&controls=0&loop=1&showinfo=0&playsinline=1&rel=0&enablejsapi=1&playlist=YOUTUBE_VIDEO_CODE</strong> </p>
    <div style="display:flex">
        <textarea name="iframe_slider" id="iframe_slider" rows="8" style="width:100%"><?php echo $iframe_slider;?></textarea>
    </div>
      
    
    <?php
}
 function slider_save_iframe($post_id) {
        
    if( isset( $_POST['iframe_slider_nonce'] ) && isset( $_POST['slider'] ) ) {

        //Not save if the user hasn't submitted changes
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
        } 

        // Verifying whether input is coming from the proper form
        if ( ! wp_verify_nonce ( $_POST['iframe_slider_nonce'] ) ) {
        return;
        } 

        // Making sure the user has permission
        if( 'post' == $_POST['slider'] ) {
               if( ! current_user_can( 'edit_post', $post_id ) ) {
                    return;
               }
               
        } 
    } 

    if (get_post_type($post_id) == 'slider') {
        
                $data = $_POST['iframe_slider'];
                update_post_meta($post_id, 'iframe_slider', $data);
    }
        
     
 }
 
add_action('save_post', 'slider_save_iframe');

?>