<?php

function copyright($atts, $content = null){
    $copyright = '<p class="copyright">&copy; '.date('Y').' Copyright '.get_bloginfo('name').'.  '.__('All rights reserved', 'airtec').' </p>';
    return $copyright;

}
add_shortcode('copyright', 'copyright');

function svg_map_marker_icon($atts, $content = null)
{
    return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67-9.535 13.774-29.93 13.773-39.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"/></svg>';
}
add_shortcode('svg_map_marker_icon', 'svg_map_marker_icon');

function svg_phone_icon($atts, $content = null)
{
    return '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0,48C0,304.47,207.91,512,464,512a24,24,0,0,0,23.39-18.6l24-104a24,24,0,0,0-13.93-27.46l-112-48a24,24,0,0,0-28,6.86l-49.6,60.62A370.9,370.9,0,0,1,130.58,204.17l60.62-49.59a24,24,0,0,0,6.86-28l-48-112A24,24,0,0,0,122.6.62l-104,24A24,24,0,0,0,0,48Z" transform="translate(0 0)"/></svg>';
}
add_shortcode('svg_phone_icon', 'svg_phone_icon');

function svg_mobile_icon($atts, $content = null)
{
    return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M272 0H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h224c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zM160 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm112-108c0 6.6-5.4 12-12 12H60c-6.6 0-12-5.4-12-12V60c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v312z"/></svg>';
}
add_shortcode('svg_mobile_icon', 'svg_mobile_icon');

function svg_email_icon($atts, $content = null)
{
    return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm0 48v40.805c-22.422 18.259-58.168 46.651-134.587 106.49-16.841 13.247-50.201 45.072-73.413 44.701-23.208.375-56.579-31.459-73.413-44.701C106.18 199.465 70.425 171.067 48 152.805V112h416zM48 400V214.398c22.914 18.251 55.409 43.862 104.938 82.646 21.857 17.205 60.134 55.186 103.062 54.955 42.717.231 80.509-37.199 103.053-54.947 49.528-38.783 82.032-64.401 104.947-82.653V400H48z"/></svg>';
}
add_shortcode('svg_email_icon', 'svg_email_icon');


function svg_facebook_icon($atts, $content = null)
{
	return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 80v352c0 26.5-21.5 48-48 48h-85.3V302.8h60.6l8.7-67.6h-69.3V192c0-19.6 5.4-32.9 33.5-32.9H384V98.7c-6.2-.8-27.4-2.7-52.2-2.7-51.6 0-87 31.5-87 89.4v49.9H184v67.6h60.9V480H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48z"/></svg>';
}
add_shortcode('svg_facebook_icon', 'svg_facebook_icon');


function svg_instagram_icon($atts, $content = null)
{
	return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>';
}
add_shortcode('svg_instagram_icon', 'svg_instagram_icon');

function svg_youtube_icon($atts, $content = null)
{
	return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M186.8 202.1l95.2 54.1-95.2 54.1V202.1zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-42 176.3s0-59.6-7.6-88.2c-4.2-15.8-16.5-28.2-32.2-32.4C337.9 128 224 128 224 128s-113.9 0-142.2 7.7c-15.7 4.2-28 16.6-32.2 32.4-7.6 28.5-7.6 88.2-7.6 88.2s0 59.6 7.6 88.2c4.2 15.8 16.5 27.7 32.2 31.9C110.1 384 224 384 224 384s113.9 0 142.2-7.7c15.7-4.2 28-16.1 32.2-31.9 7.6-28.5 7.6-88.1 7.6-88.1z"/></svg>';
}
add_shortcode('svg_youtube_icon', 'svg_youtube_icon');

function svg_testimonials_icon($atts, $content = null)
{
	return '<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 55 55" style="enable-background:new 0 0 55 55;" xml:space="preserve"><path d="M55,27.5C55,12.337,42.663,0,27.5,0S0,12.337,0,27.5c0,8.009,3.444,15.228,8.926,20.258l-0.026,0.023l0.892,0.752
	c0.058,0.049,0.121,0.089,0.179,0.137c0.474,0.393,0.965,0.766,1.465,1.127c0.162,0.117,0.324,0.234,0.489,0.348
	c0.534,0.368,1.082,0.717,1.642,1.048c0.122,0.072,0.245,0.142,0.368,0.212c0.613,0.349,1.239,0.678,1.88,0.98
	c0.047,0.022,0.095,0.042,0.142,0.064c2.089,0.971,4.319,1.684,6.651,2.105c0.061,0.011,0.122,0.022,0.184,0.033
	c0.724,0.125,1.456,0.225,2.197,0.292c0.09,0.008,0.18,0.013,0.271,0.021C25.998,54.961,26.744,55,27.5,55
	c0.749,0,1.488-0.039,2.222-0.098c0.093-0.008,0.186-0.013,0.279-0.021c0.735-0.067,1.461-0.164,2.178-0.287
	c0.062-0.011,0.125-0.022,0.187-0.034c2.297-0.412,4.495-1.109,6.557-2.055c0.076-0.035,0.153-0.068,0.229-0.104
	c0.617-0.29,1.22-0.603,1.811-0.936c0.147-0.083,0.293-0.167,0.439-0.253c0.538-0.317,1.067-0.648,1.581-1
	c0.185-0.126,0.366-0.259,0.549-0.391c0.439-0.316,0.87-0.642,1.289-0.983c0.093-0.075,0.193-0.14,0.284-0.217l0.915-0.764
	l-0.027-0.023C51.523,42.802,55,35.55,55,27.5z M2,27.5C2,13.439,13.439,2,27.5,2S53,13.439,53,27.5
	c0,7.577-3.325,14.389-8.589,19.063c-0.294-0.203-0.59-0.385-0.893-0.537l-8.467-4.233c-0.76-0.38-1.232-1.144-1.232-1.993v-2.957
	c0.196-0.242,0.403-0.516,0.617-0.817c1.096-1.548,1.975-3.27,2.616-5.123c1.267-0.602,2.085-1.864,2.085-3.289v-3.545
	c0-0.867-0.318-1.708-0.887-2.369v-4.667c0.052-0.52,0.236-3.448-1.883-5.864C34.524,9.065,31.541,8,27.5,8
	s-7.024,1.065-8.867,3.168c-2.119,2.416-1.935,5.346-1.883,5.864v4.667c-0.568,0.661-0.887,1.502-0.887,2.369v3.545
	c0,1.101,0.494,2.128,1.34,2.821c0.81,3.173,2.477,5.575,3.093,6.389v2.894c0,0.816-0.445,1.566-1.162,1.958l-7.907,4.313 c-0.252,0.137-0.502,0.297-0.752,0.476C5.276,41.792,2,35.022,2,27.5z"/></svg>';
}
add_shortcode('svg_testimonials_icon', 'svg_testimonials_icon');




function our_team($atts, $content = null) {


        
    	
            	$args = array(
            	    'post_type'=>'team-member', 
            	    'post_status' => 'publish', 
            	    'orderby' => 'menu_order',
            	    'order' => 'ASC',
            	    'posts_per_page'=>-1,
                );
            	
            	
                
            	
            	
            	$latest_query = new WP_Query($args);
                
                
                $latest = '';
            	if($latest_query->have_posts()){
            	    $latest .= '<div class="team-all-member team-department">';
            	    $latest .= '<div class="team-member-list grid-x grid-padding-x small-up-1 medium-up-2 large-up-3">';
            			while ( $latest_query->have_posts() ) {
            				$latest_query->the_post();
                            $post_id = get_the_ID();
                            $member_pos = get_post_meta($post_id,'team_member_position',true);
                            $latest .= '<div class="cell team-member-item">';
                            	$latest .= '<div id="team-member-'.$post_id.'" class="item-simple-team-member-view text-center">';
                            	    $exceprt = get_the_content($post_id);
                            	    $latest .= '<div class="item-simple-team-member-thumb no-bg">';
                            	        if ( has_post_thumbnail($post_id)) {
                            	            $latest .= get_the_post_thumbnail($post_id,'full');
                            	        } else {
                            	            $latest .= '<div class="default-team-member-img"></div>';
                            	        }
                            	    $latest .= '</div>';
                            	    $latest .= '<p class="item-simple-team-member-title  text-left">';
                            	    $latest .= get_the_title($post_id);
                            	    if (!empty($member_pos)) $latest .= '<span class="team-member-position">'.$member_pos.'</span>';
                            	    $latest .= '</p>';
                            	    //$latest .= '<p class="item-simple-team-member-excerpt">'.$exceprt.'</p>';
                            	    
                            	$latest .= '</div>';
            			    $latest .= '</div>';
            			}
            			wp_reset_postdata();
            		
                    $latest .= '</div></div>';
            	}
  
  
  
  
  
    return $latest;
    

    
}
add_shortcode('our_team', 'our_team');






function latest_projects($atts, $content = null) {


        global $post;
    	
            	$args = array(
            	    'post_type'=>'project', 
            	    'post_status' => 'publish', 
            	    'orderby' => 'menu_order',
            	    'order' => 'ASC',
            	    'posts_per_page'=> -1,
                );
            	
            	if (get_post_type($post) == 'project') {
            	    $custom_term = get_the_terms($post->ID,'project-category');
            	    $args['post__not_in']  = array($post->ID);
            	    $args['tax_query'] = array(
            	        array(
                	        'taxonomy' => 'project-category',
                            'field' => 'slug',
                            'terms' => $custom_term[0]->slug,
            	        )
            	    );
            	}
            	
                
            	
            	
            	$latest_query = new WP_Query($args);
                
                
                $latest = '';
            	if($latest_query->have_posts()){
            	    $latest .= '<div class="latest-projects">';
            			while ( $latest_query->have_posts() ) {
            				$latest_query->the_post();
                            $post_id = get_the_ID();
                            $member_pos = get_post_meta($post_id,'team_member_position',true);
                            $latest .= '<div class="single-latest-project">';
                                $latest .=  '<div class="post-loop-info">';                
    		                        $latest .=  '<h3 class="post-loop-title" style="text-transform: lowercase;"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>';
                                    $cat = get_the_terms(get_the_ID(),'project-category');
                                    $category = $cat[0]->name;
                        		    $category_link = get_term_link($category,'project-category');
                                    if (!empty($category)) $latest .=  '<p class="post-loop-category"><a class="uppercase" href="'.$category_link.'"><strong>'.$category.'</strong></a></p>';
                                $latest .= '</div>';
                			    $latest .= '<div class="post-loop-image" style="background-image:url('.get_the_post_thumbnail_url(get_the_ID(),"full").')">';
                        			$latest .= '<a href="'.get_the_permalink().'" title="'.get_the_title().'">';
                        			    $latest .= get_the_post_thumbnail();
                        			$latest .= '</a>';
                        		$latest .= '</div>';
            			    $latest .= '</div>';
            			}
            			wp_reset_postdata();
            		
                    $latest .= '</div>';
            	}
  
  
  
  
  
    return $latest;
    

    
}
add_shortcode('latest_projects', 'latest_projects');