<?php

// Remove 'text/css' from our enqueued stylesheet
function sb_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}
add_filter('style_loader_tag', 'sb_style_remove');

// Remove script version from javascripts and css
function sb_remove_script_version($src){
	 $parts = explode('?ver=', $src);
	 return $parts[0];
}
add_filter('script_loader_src', 'sb_remove_script_version', 15, 1);
add_filter('style_loader_src', 'sb_remove_script_version', 15, 1);

// Remove <p> tags from Excerpt altogether
remove_filter('the_excerpt', 'wpautop');

// Custom Gravatar in Settings > Discussion
function sbblankgravatar ($avatar_defaults)
{
    $myavatar = get_template_directory_uri() . '/assets/media/images/gravatar.jpg';
    $avatar_defaults[$myavatar] = "Custom Gravatar";
    return $avatar_defaults;
}
add_filter('avatar_defaults', 'sbblankgravatar');
