<!doctype html>
<html <?php language_attributes(); ?> class="no-js"  style="scroll-behavior: smooth;">
    <head>        <meta charset="<?php bloginfo('charset'); ?>">
        <?php 
        global $wp_query;
        $page_title = '';
        $seo_title = get_bloginfo('name');
        if (is_front_page()) {
            $page_title = str_replace('|',' ',get_the_title());
            $seo_title = $page_title.' - '.$seo_title;
            $seo_description = get_bloginfo('description');
            $yoast_title = get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_post_meta(get_the_ID(), '_yoast_wpseo_metadesc', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
            $yoast_title = get_post_meta(get_the_ID(), 'rank_math_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_post_meta(get_the_ID(), 'rank_math_description', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
        } elseif (is_category() || is_tax() ) {
            $term = get_queried_object();
            $page_title = $term->name;
            $page_description = $term->description;
            $seo_description = $page_description;
            $seo_title = $page_title.' - '.$seo_title;
            $yoast_title = get_term_meta($term->term_id, '_yoast_wpseo_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_term_meta($term->term_id, '_yoast_wpseo_metadesc', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
            $yoast_title = get_term_meta($term->term_id, 'rank_math_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_term_meta($term->term_id, 'rank_math_description', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
        } elseif (is_post_type_archive('project')) {
            $page_title = 'PROJECTS';
            $page_description = '';
            $seo_description = $page_description;
            $seo_title = $page_title.' - '.$seo_title;
        }  elseif (is_post_type_archive('post')) {
            $page_title = 'ARTICLES';
            $page_description = '';
            $seo_description = $page_description;
            $seo_title = $page_title.' - '.$seo_title;
        } elseif (is_404()) {
            $page_title = 'Page Not Found';
            $page_description = '404';
            $seo_description = $page_description;
            $seo_title = $page_title.' - '.$seo_title;
        } else {
            $page_title = str_replace('|',' ',get_the_title());
            $page_description = wp_trim_words(get_the_excerpt(), $num_words = 20, $more = null );
            $seo_description = $page_description;
            $seo_title = $page_title.' - '.$seo_title;
            
            $yoast_title = get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_post_meta(get_the_ID(), '_yoast_wpseo_metadesc', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
            $yoast_title = get_post_meta(get_the_ID(), 'rank_math_title', true);
            if (!empty($yoast_title)) $seo_title = $yoast_title;
            $yoast_desc = get_post_meta(get_the_ID(), 'rank_math_description', true);
            if (!empty($yoast_desc)) $seo_description = $yoast_desc;
        }
        
        ?>
        <title><?php echo $seo_title; ?></title>
        <?php if (!empty($seo_description)) { ?><meta name="description" content="<?php echo $seo_description; ?>"><?php } ?>


        <link rel='preconnect' href='//fonts.googleapis.com' />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel='dns-prefetch' href='//maps.googleapis.com' />
        <link rel='dns-prefetch' href='//www.googletagmanager.com' />
        <link rel='dns-prefetch' href='//code.jquery.com' />
        <link href="humans.txt" rel="author" />

        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php wp_head(); ?>
        <script>
        jQuery.event.special.touchstart = {
            setup: function( _, ns, handle ){
                this.addEventListener("touchstart", handle, { passive: true });
            }
        };
        </script>
    </head>
    <body <?php body_class(); ?> id="body-top">
        <!--[if lt IE 8]>
            <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->
        
        <div class="cursor"></div>
        <div class="off-canvas position-left" id="offCanvasMenu" data-transition="overlap" data-off-canvas>
            
            <?php sb_main_mobile_navigation(); ?>
            <?php echo do_shortcode('[show_social show="1" withicon="false" inline="" seperator="" label=""]');?>
        </div>
        <!-- wrapper -->
        <div class="wrapper off-canvas-content" data-off-canvas-content >
            <div class="grid-container mobile-menu-container">
                <div class="grid-x mobile-menu">
                    <div class="small-3 cell text-left">
                        
                        <!-- logo -->
                        <div class="logo">
                            <figure class="wp-block-image size-full">
                            <a href="<?php echo home_url(); ?>" >
                                <!--
                                <svg  width="85" height="25" viewBox="0 0 85 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g> <g id="Group"> <path id="Vector" d="M45.8053 7.09478H39.9473V3.31958H45.8053C45.9355 3.31958 46.0006 3.44976 46.0006 3.51485V6.83442C46.0657 6.9646 45.9355 7.09478 45.8053 7.09478Z" fill="black"/> <path id="Vector_2" d="M64.5513 24.5388H57.4565C52.7049 24.5388 48.7996 20.6985 48.7996 15.8819V4.10065C48.7996 3.71012 49.125 3.31958 49.5806 3.31958H59.6044C63.9004 3.31958 66.569 5.66281 66.7643 9.69837C66.8294 11.6511 66.3087 13.3434 65.1371 14.515C63.9004 15.8168 62.0778 16.4677 59.7346 16.4677H55.634C55.5038 16.4677 55.4387 16.3375 55.4387 16.2724V12.9528C55.4387 12.8227 55.5689 12.7576 55.634 12.7576H59.7346C60.6459 12.7576 61.8175 12.6274 62.4033 11.9765C62.8589 11.5209 63.0542 10.87 62.9891 9.89363C62.924 8.46166 62.4684 7.15987 59.6044 7.15987H52.5748V15.947C52.5748 18.6156 54.7878 20.8287 57.4565 20.8287H64.5513C64.6814 20.8287 64.7465 20.9589 64.7465 21.024V24.3435C64.7465 24.4086 64.6814 24.5388 64.5513 24.5388Z" fill="black"/> <path id="Vector_3" d="M5.18957 3.31958H10.0062C14.7577 3.31958 18.6631 7.15987 18.6631 11.9765V24.2784C18.6631 24.4086 18.5329 24.4737 18.4679 24.4737H7.92333C3.62741 24.4737 0.958739 22.1305 0.76347 18.0949C0.69838 16.1422 1.2191 14.4499 2.39071 13.2783C3.62741 11.9765 5.44992 11.3256 7.79315 11.3256H11.8938C12.024 11.3256 12.0891 11.4558 12.0891 11.5209V14.8404C12.0891 14.9706 11.9589 15.0357 11.8938 15.0357H7.79315C6.8819 15.0357 5.71028 15.1659 5.12448 15.8168C4.66885 16.2724 4.47358 16.9233 4.53867 17.8997C4.60376 19.3316 5.05939 20.6334 7.92333 20.6334H14.953V11.9765C14.953 9.30783 12.74 7.09478 10.0713 7.09478H5.18957C5.05939 7.09478 4.9943 6.9646 4.9943 6.89951V3.57994C4.9943 3.44976 5.05939 3.31958 5.18957 3.31958Z" fill="black"/> <path id="Vector_4" d="M24.9768 9.89365H21.6572C21.527 9.89365 21.4619 10.0238 21.4619 10.0889V24.2785C21.4619 24.4086 21.5921 24.4737 21.6572 24.4737H24.9768C25.1069 24.4737 25.172 24.3435 25.172 24.2785V10.0889C25.2371 9.95874 25.1069 9.89365 24.9768 9.89365Z" fill="black"/> <path id="Vector_5" d="M24.9768 3.31958H21.6572C21.527 3.31958 21.4619 3.44976 21.4619 3.51485V6.83442C21.4619 6.9646 21.5921 7.02969 21.6572 7.02969H24.9768C25.1069 7.02969 25.172 6.89951 25.172 6.83442V3.51485C25.2371 3.38467 25.1069 3.31958 24.9768 3.31958Z" fill="#D32027"/> <path id="Vector_6" d="M72.3619 11.9765V20.7636H84.3384C84.4685 20.7636 84.5336 20.8938 84.5336 20.9589V24.2784C84.5336 24.4086 84.4035 24.4737 84.3384 24.4737H72.3619C70.279 24.4737 68.5867 22.7814 68.5867 20.6985V11.9765C68.5867 7.22496 72.427 3.31958 77.2436 3.31958H84.3384C84.4685 3.31958 84.5336 3.44976 84.5336 3.51485V6.83442C84.5336 6.9646 84.4035 7.02969 84.3384 7.02969H77.2436C74.5749 7.09478 72.3619 9.24274 72.3619 11.9765Z" fill="black"/> <path id="Vector_7" d="M31.7461 20.7636V11.9765C31.7461 9.30786 33.9592 7.09481 36.6279 7.09481H37.2137C37.3439 7.09481 37.4089 6.96463 37.4089 6.89954V3.57997C37.4089 3.44979 37.2788 3.3847 37.2137 3.3847H36.6279C31.8763 3.3847 27.9709 7.22499 27.9709 12.0416V24.3436C27.9709 24.4737 28.1011 24.5388 28.1662 24.5388H31.4858C31.616 24.5388 31.6811 24.4087 31.6811 24.3436V20.7636H31.7461Z" fill="black"/> <path id="Vector_8" d="M43.0064 7.09478V15.8819C43.0064 18.5506 45.2194 20.7636 47.8881 20.7636H48.4739C48.6041 20.7636 48.6692 20.8938 48.6692 20.9589V24.2784C48.6692 24.4086 48.539 24.4737 48.4739 24.4737H47.8881C43.1366 24.4737 39.2312 20.6334 39.2312 15.8168V3.31958H43.0064V7.09478Z" fill="black"/> <path id="Vector_9" d="M43.0067 4.42609V3.71011V0.195268C43.0067 0.0650891 42.8766 0 42.8115 0H39.4919C39.3617 0 39.2966 0.130179 39.2966 0.195268V4.42609H43.0067Z" fill="black"/> </g> </g> </svg>
                                -->
                                <svg id="airtec-logo" width="100" height="41" viewBox="0 0 100 41" fill="none" xmlns="http://www.w3.org/2000/svg"> <g id="AIRTEC_Logo-fin-01 1"> <g id="Group"> <g id="Layer_1"> <path id="Vector" d="M31.147 4.1611H22.2065V8.17672H31.147V4.1611Z" fill="black"/> <path id="Vector_2" d="M31.2051 9.57346H22.2065V28.3421H31.2051V9.57346Z" fill="black"/> <g id="Clip path group"> <mask id="mask0_362_624" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="2" y="4" width="96" height="33"> <g id="clippath"> <path id="Vector_3" d="M97.1555 4.1611H2.81592V36.6934H97.1555V4.1611Z" fill="white"/> </g> </mask> <g mask="url(#mask0_362_624)"> <g id="Group_2"> <path id="Vector_4" d="M50.3343 15.626V13.6182C50.3343 11.4067 48.5346 9.60254 46.3285 9.60254H32.6274V28.3712H41.2196V13.0944H41.2486H42.642V15.6551H50.3633L50.3343 15.626Z" fill="black"/> </g> </g> </g> <path id="Vector_5" d="M48.1572 4.1611V8.14762H51.7276V28.4294H61.1035V8.14762H64.6739V4.1611H48.1572Z" fill="black"/> <g id="Clip path group_2"> <mask id="mask1_362_624" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="2" y="4" width="96" height="33"> <g id="clippath-1"> <path id="Vector_6" d="M97.1555 4.1611H2.81592V36.6934H97.1555V4.1611Z" fill="white"/> </g> </mask> <g mask="url(#mask1_362_624)"> <g id="Group_3"> <path id="Vector_7" d="M20.7838 28.3421V13.269C20.7838 11.2321 19.1292 9.57346 17.0973 9.57346H7.37303C4.87666 9.57346 2.84473 11.6104 2.84473 14.1128V15.5969H10.9724V13.0944H12.4238V24.5302H10.9724V17.0227H7.51817C6.56026 17.0227 5.68943 17.3137 4.93471 17.8375C4.64444 18.0412 4.38319 18.274 4.12194 18.5358C3.80264 18.8559 3.54139 19.2342 3.3382 19.6125C3.01889 20.1945 2.84473 20.8346 2.84473 21.533V23.6863C2.84473 26.7999 4.58638 28.3712 8.06969 28.3712H20.8128L20.7838 28.3421Z" fill="black"/> <path id="Vector_8" d="M71.3498 22.4642V24.5011H69.8984V13.0653H71.3498V21.0383H78.7518V14.2292C78.7518 11.6977 76.6908 9.63165 74.1655 9.63165H67.1117C64.5863 9.63165 62.5254 11.6977 62.5254 14.2292V23.7736C62.5254 26.3052 64.5863 28.3712 67.402 28.3712H74.4557C76.7199 28.3712 78.7808 26.3052 78.7808 23.7736V22.4351H71.3788L71.3498 22.4642Z" fill="black"/> <path id="Vector_9" d="M89.4922 22.4642V24.5011H88.0408V13.0653H89.4922V15.6551H97.1845V14.0838C97.1845 11.6395 95.2106 9.66077 92.7723 9.66077H84.5865C82.1482 9.66077 80.1743 11.6395 80.1743 14.0838V24.0355C80.1743 26.4798 82.1482 28.4585 84.5865 28.4585H92.7723C95.2106 28.4585 97.1845 26.4798 97.1845 24.0355V22.4642H89.4922Z" fill="black"/> <path id="Vector_10" d="M93.701 36.286C94.0203 36.5479 94.4558 36.6934 95.0363 36.6934C95.6169 36.6934 95.762 36.6352 96.0233 36.5188C96.2845 36.4024 96.4877 36.2278 96.6328 35.995C96.778 35.7622 96.8651 35.5295 96.8651 35.2676C96.8651 35.0057 96.807 34.7438 96.6909 34.5401C96.5748 34.3364 96.4006 34.1909 96.1974 34.0745C95.9942 33.9581 95.6459 33.8417 95.2105 33.7544C94.7751 33.638 94.4848 33.5507 94.3687 33.4343C94.2816 33.3471 94.2235 33.2598 94.2235 33.1434C94.2235 33.027 94.2816 32.9397 94.3687 32.8524C94.5138 32.736 94.717 32.6778 95.0073 32.6778C95.2976 32.6778 95.4717 32.736 95.5878 32.8233C95.7039 32.9397 95.791 33.0852 95.8491 33.318H96.778C96.778 32.8524 96.6038 32.5323 96.3135 32.2704C96.0233 32.0085 95.5878 31.8921 95.0073 31.8921C94.4267 31.8921 94.3687 31.9503 94.1074 32.0376C93.8462 32.154 93.672 32.2995 93.5269 32.5032C93.3818 32.7069 93.3237 32.9106 93.3237 33.1725C93.3237 33.5216 93.4688 33.8417 93.7591 34.1036C93.9623 34.2782 94.3106 34.4237 94.8041 34.5692C95.1815 34.6565 95.4427 34.7438 95.5298 34.7729C95.6749 34.8311 95.791 34.8893 95.8491 34.9766C95.9072 35.0639 95.9362 35.1512 95.9362 35.2676C95.9362 35.4422 95.8491 35.5876 95.704 35.704C95.5588 35.8204 95.3266 35.8786 95.0363 35.8786C94.746 35.8786 94.5429 35.8204 94.3687 35.6749C94.1945 35.5295 94.1074 35.3258 94.0494 35.0057L93.1495 35.093C93.2076 35.6167 93.3817 35.995 93.701 36.2569M86.3861 36.6061V33.6089L88.2148 36.6061H89.1437V32.0376H88.2729V35.093L86.4151 32.0376H85.5153V36.6061H86.3861ZM78.4325 33.1434C78.6648 32.8815 78.9841 32.7651 79.3614 32.7651C79.7388 32.7651 80.0581 32.8815 80.2903 33.1434C80.5225 33.4053 80.6386 33.7835 80.6386 34.3073C80.6386 34.8311 80.5225 35.2385 80.2903 35.5004C80.0581 35.7622 79.7388 35.9077 79.3905 35.9077C79.0421 35.9077 78.7228 35.7622 78.4906 35.5004C78.2584 35.2385 78.1423 34.8311 78.1423 34.3073C78.1423 33.7835 78.2584 33.3762 78.4906 33.1143M77.7359 36.0823C78.1423 36.4897 78.6648 36.6934 79.3614 36.6934C80.0581 36.6934 80.5806 36.4897 80.9579 36.0532C81.3643 35.6458 81.5675 35.0639 81.5675 34.3073C81.5675 33.5507 81.3643 32.9688 80.9579 32.5614C80.5516 32.154 80.0291 31.9212 79.3324 31.9212C78.6357 31.9212 78.6357 31.9794 78.3455 32.0958C78.1423 32.1831 77.9391 32.3286 77.7649 32.5032C77.5907 32.6778 77.4456 32.9106 77.3295 33.1434C77.1844 33.4634 77.1263 33.8417 77.1263 34.3073C77.1263 35.0348 77.3295 35.6167 77.7359 36.0241M73.1786 32.0376H72.2497V36.6061H73.1786V32.0376ZM67.0828 36.6061V32.7942H68.4471V32.0085H64.8186V32.7942H66.1829V36.6061H67.1118H67.0828ZM59.8259 35.6749C59.6517 35.8204 59.4485 35.9077 59.1873 35.9077C58.926 35.9077 58.5777 35.7913 58.3745 35.5295C58.1713 35.2676 58.0552 34.8602 58.0552 34.2782C58.0552 33.6962 58.1713 33.3471 58.3745 33.0852C58.5777 32.8524 58.868 32.7069 59.1873 32.7069C59.5066 32.7069 59.6517 32.7651 59.8259 32.9106C60 33.0561 60.1161 33.2307 60.1742 33.4634L61.074 33.2307C60.9579 32.8524 60.8128 32.5905 60.6096 32.3868C60.2613 32.0667 59.7968 31.8921 59.2453 31.8921C58.6938 31.8921 58.0842 32.0958 57.7068 32.5323C57.3005 32.9688 57.1263 33.5507 57.1263 34.3073C57.1263 35.0639 57.3295 35.5877 57.7068 36.0241C58.0842 36.4315 58.6067 36.6352 59.2163 36.6352C59.8259 36.6352 60.1161 36.5188 60.4354 36.2569C60.7547 36.0241 60.987 35.6458 61.1321 35.1512L60.2322 34.8602C60.1452 35.2094 60.0291 35.4422 59.8549 35.5877M49.434 34.4819C49.434 35.0057 49.463 35.384 49.5211 35.6458C49.5501 35.8204 49.6372 35.995 49.7823 36.1405C49.9275 36.286 50.1016 36.4315 50.3048 36.5479C50.537 36.6352 50.8563 36.6934 51.2918 36.6934C51.7272 36.6934 51.9594 36.6352 52.1626 36.5479C52.3948 36.4606 52.569 36.3442 52.7141 36.1696C52.8592 36.0241 52.9463 35.8204 53.0044 35.5877C53.0624 35.3549 53.0915 34.9766 53.0915 34.4237V32.0085H52.1626V34.5401C52.1626 34.8893 52.1626 35.1512 52.1336 35.3258C52.1336 35.4713 52.0174 35.6167 51.9013 35.7331C51.7562 35.8495 51.582 35.9077 51.3208 35.9077C51.0595 35.9077 50.8563 35.8495 50.7112 35.7331C50.5661 35.6167 50.479 35.4713 50.4209 35.2676C50.4209 35.1512 50.3919 34.8893 50.3919 34.511V32.0376H49.463V34.4819H49.434ZM42.4964 32.8233H43.2221C43.5994 32.8233 43.8317 32.8233 43.8897 32.8233C44.0349 32.8233 44.151 32.9106 44.2381 32.9979C44.3251 33.0852 44.3542 33.2307 44.3542 33.3762C44.3542 33.5216 44.3251 33.638 44.2671 33.7253C44.209 33.8126 44.1219 33.8708 44.0058 33.929C43.8897 33.9581 43.6285 33.9872 43.164 33.9872H42.4674V32.8233H42.4964ZM42.4964 36.6061V34.6856H42.6706C42.8738 34.6856 43.0479 34.6856 43.135 34.7438C43.2221 34.7729 43.3382 34.8311 43.4253 34.9475C43.5124 35.0348 43.6865 35.2676 43.9188 35.6167L44.5864 36.6061H45.6894L45.1379 35.704C44.9057 35.3549 44.7315 35.093 44.6154 34.9475C44.4993 34.802 44.3251 34.6856 44.1219 34.5692C44.5283 34.511 44.8186 34.3655 45.0218 34.1327C45.225 33.8999 45.3121 33.638 45.3121 33.2889C45.3121 32.9397 45.254 32.7651 45.1089 32.5614C44.9637 32.3577 44.7896 32.2122 44.5864 32.1249C44.3542 32.0376 44.0058 32.0085 43.5124 32.0085H41.5675V36.577H42.4964V36.6061ZM36.3716 36.6061V32.7942H37.7359V32.0085H34.1074V32.7942H35.4717V36.6061H36.4006H36.3716ZM27.2279 36.286C27.5472 36.5479 27.9826 36.6934 28.5632 36.6934C29.1437 36.6934 29.2889 36.6352 29.5501 36.5188C29.8113 36.4024 30.0145 36.2278 30.1597 35.995C30.3048 35.7622 30.3919 35.5295 30.3919 35.2676C30.3919 35.0057 30.3338 34.7438 30.2177 34.5401C30.1016 34.3364 29.9275 34.1909 29.7243 34.0745C29.5211 33.9581 29.1727 33.8417 28.7373 33.7544C28.3019 33.638 28.0116 33.5507 27.8955 33.4343C27.8084 33.3471 27.7504 33.2598 27.7504 33.1434C27.7504 33.027 27.8084 32.9397 27.8955 32.8524C28.0407 32.736 28.2439 32.6778 28.5341 32.6778C28.8244 32.6778 28.9986 32.736 29.1147 32.8233C29.2308 32.9397 29.3179 33.0852 29.3759 33.318H30.3048C30.3048 32.8524 30.1306 32.5323 29.8404 32.2704C29.5501 32.0085 29.1147 31.8921 28.5341 31.8921C27.9536 31.8921 27.8955 31.9503 27.6343 32.0376C27.373 32.154 27.1989 32.2995 27.0537 32.5032C26.9086 32.7069 26.8505 32.9106 26.8505 33.1725C26.8505 33.5216 26.9957 33.8417 27.2569 34.1036C27.4601 34.2782 27.8084 34.4237 28.3019 34.5692C28.6793 34.6565 28.9405 34.7438 29.0276 34.7729C29.1727 34.8311 29.2888 34.8893 29.3469 34.9766C29.405 35.0639 29.434 35.1512 29.434 35.2676C29.434 35.4422 29.3469 35.5876 29.2018 35.704C29.0566 35.8204 28.8244 35.8786 28.5341 35.8786C28.2439 35.8786 28.0407 35.8204 27.8665 35.6749C27.6923 35.5295 27.6052 35.3258 27.5472 35.0057L26.6473 35.093C26.7054 35.6167 26.8796 35.995 27.1989 36.2569M19.942 36.6061V33.6089L21.7707 36.6061H22.6996V32.0376H21.8288V35.093L19.971 32.0376H19.0711V36.6061H19.942ZM11.9594 33.1434C12.1916 32.8815 12.5109 32.7651 12.8883 32.7651C13.2656 32.7651 13.5849 32.8815 13.8172 33.1434C14.0494 33.4053 14.1655 33.7835 14.1655 34.3073C14.1655 34.8311 14.0494 35.2385 13.8172 35.5004C13.5849 35.7622 13.2656 35.9077 12.9173 35.9077C12.569 35.9077 12.2497 35.7622 12.0174 35.5004C11.7852 35.2385 11.6691 34.8311 11.6691 34.3073C11.6691 33.7835 11.7852 33.3762 12.0174 33.1143M11.2627 36.0823C11.6691 36.4897 12.1916 36.6934 12.8883 36.6934C13.5849 36.6934 14.1074 36.4897 14.4848 36.0532C14.8912 35.6458 15.0944 35.0639 15.0944 34.3073C15.0944 33.5507 14.8912 32.9688 14.4848 32.5614C14.0784 32.154 13.5559 31.9212 12.8592 31.9212C12.1626 31.9212 12.1626 31.9794 11.8723 32.0958C11.6691 32.1831 11.4659 32.3286 11.2918 32.5032C11.1176 32.6778 10.9724 32.9106 10.8563 33.1434C10.7112 33.4634 10.6531 33.8417 10.6531 34.3073C10.6531 35.0348 10.8563 35.6167 11.2627 36.0241M5.54429 35.6749C5.37013 35.8204 5.16693 35.9077 4.90568 35.9077C4.64444 35.9077 4.29611 35.7913 4.09291 35.5295C3.88972 35.2676 3.77361 34.8602 3.77361 34.2782C3.77361 33.6962 3.88972 33.3471 4.09291 33.0852C4.29611 32.8524 4.58638 32.7069 4.90568 32.7069C5.22499 32.7069 5.37013 32.7651 5.54429 32.9106C5.71846 33.0561 5.83457 33.2307 5.89262 33.4634L6.79248 33.2307C6.67637 32.8524 6.53123 32.5905 6.32804 32.3868C5.9797 32.0667 5.51526 31.8921 4.96374 31.8921C4.41222 31.8921 3.80264 32.0958 3.42528 32.5323C3.01889 32.9688 2.84473 33.5507 2.84473 34.3073C2.84473 35.0639 3.04792 35.5877 3.42528 36.0241C3.80264 36.4315 4.32513 36.6352 4.93471 36.6352C5.54429 36.6352 5.83457 36.5188 6.15387 36.2569C6.47317 36.0241 6.70539 35.6458 6.85053 35.1512L5.95068 34.8602C5.86359 35.2094 5.74748 35.4422 5.57332 35.5877" fill="black"/> </g> </g> </g> </g> </g> </g> </svg>
                                
                                <?php
                                    /*
                                    $logo_id = custom_get_theme_option( 'site_logo' );
                                    if (!empty($logo_id)){ ?>
                                        <img src="<?php echo $logo_id; ?>" alt="<?php echo get_bloginfo('name');?>">
                                    <?php } else {
                                        echo get_bloginfo('name');
                                    }
                                    */
                                ?>
                            </a>
                            </figure>
                        </div>
                        <!-- /logo -->
                        
                        <a href="#" aria-label="Menu" class="mobile-menu-link" data-toggle="offCanvasMenu" aria-expanded="false" aria-controls="offCanvasMenu" onclick="return false;">MENU</a>
                    </div>
                    <div class="small-6 cell text-center">
                    </div>
                    <div class="small-3 cell text-right">
                        <?php if(!function_exists('dynamic_sidebar') || !dynamic_sidebar('top-header-widget-area-2')) ?>
                    </div>
                </div>
            </div>