<?php


function theme_theme_data_block_admin() {
   wp_enqueue_script(
      'theme_theme_data',
      get_stylesheet_directory_uri(). '/blocks/theme_data/block.js',
      array( 'wp-blocks', 'wp-element' )
   );
   wp_enqueue_style(
      'theme_theme_data_editor',
      get_stylesheet_directory_uri(). '/blocks/theme_data/admin-block.css',
      array()
   );

}
add_action( 'enqueue_block_editor_assets', 'theme_theme_data_block_admin' );

function add_file_types_to_uploads($file_types){
    $new_filetypes = array();
    $new_filetypes['svg'] = 'image/svg+xml';
    $file_types = array_merge($file_types, $new_filetypes );
    return $file_types;
}
add_filter('upload_mimes', 'add_file_types_to_uploads');

function theme_shortcode($atts, $content = null) {
    $a = shortcode_atts( array(
        'shortcode' => '',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    
    $sc = $a['shortcode'];
    
    $shortcode = '';
    $show = '1';
    
    if ($a["withicon"] == 'undefined') $wi = false; else $wi = true;
    if ($a["inline"] == 'undefined') $in = false; else $in = true;
    if ($a["seperator"] == 'undefined') $sep = ''; else $sep = $a["seperator"];
    if ($a["label"] == 'undefined') $lab = ''; else $lab = $a["label"];
    
    if ($sc == 'show_all_addresses') {$shortcode = 'show_addresses'; $show='all';}
    elseif ($sc == 'show_address_1') {$shortcode = 'show_addresses'; $show='1';}
    elseif ($sc == 'show_address_2') {$shortcode = 'show_addresses'; $show='2';}
    
    else if ($sc == 'show_all_phones_mobiles') {$shortcode = 'show_phones_mobiles'; $show='all';}
    else if ($sc == 'show_all_phones') {$shortcode = 'show_phones'; $show='all';}
    elseif ($sc == 'show_phone_1') {$shortcode = 'show_phones'; $show='1';}
    elseif ($sc == 'show_phone_2') {$shortcode = 'show_phones'; $show='2';}
    
    else if ($sc == 'show_all_mobiles') {$shortcode = 'show_mobiles'; $show='all';}
    elseif ($sc == 'show_mobile_1') {$shortcode = 'show_mobiles'; $show='1';}
    elseif ($sc == 'show_mobile_2') {$shortcode = 'show_mobiles'; $show='2';}
    
    else if ($sc == 'show_all_emails') {$shortcode = 'show_emails'; $show='all';}
    elseif ($sc == 'show_email_1') {$shortcode = 'show_emails'; $show='1';}
    elseif ($sc == 'show_email_2') {$shortcode = 'show_emails'; $show='2';}
    
    elseif ($sc == 'show_ifram_1') {$shortcode = 'show_iframes'; $show='1';}
    elseif ($sc == 'show_ifram_2') {$shortcode = 'show_iframes'; $show='2';}
    
    else if ($sc == 'show_working_hours') {$shortcode = 'show_working_hours'; $show='all';}
    
    else if ($sc == 'show_social') {$shortcode = 'show_social'; $show='all';}
    
    
    $output = do_shortcode('['.$shortcode.' show="'.$show.'" withicon="'.$wi.'" inline="'.$in.'" seperator="'.$sep.'" label="'.$lab.'"]');
    
    return $output;
}
add_shortcode('theme_shortcode', 'theme_shortcode');





function show_addresses($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $addresses = 0;
    if (custom_get_theme_option('address_1_'.$lang)) $addresses++; 
    if (custom_get_theme_option('address_2_'.$lang)) $addresses++; 
    if ($addresses > 0) { 
        if ($inline) $l = 'span'; else $l = 'div';
        $return .= '<'.$l.' class="contact-data big-font address';
            if ($icon) $return .= ' with-icon"><span class="contact-data-icon">'.do_shortcode('[icon_map]').'</span>'; else  $return .= '">';
            if (!empty($label)) $return .= '<'.$l.' class="contact-data-title">'.$label.'</'.$l.'>';
            $return .= '<'.$l.' class="contact-data-info">';
                if (custom_get_theme_option('address_1_'.$lang) && ($show == 'all' || $show == '1')) {
                    $return .= '<'.$l.' class="address-1">';
                    if (custom_get_theme_option('gmap_1_'.$lang)) $return .= '<a href="'.custom_get_theme_option('gmap_1_'.$lang).'" target="_blank">';
                    $return .= str_replace('|','<br>',custom_get_theme_option('address_1_'.$lang));
                    if (custom_get_theme_option('gmap_1_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
                if ($addresses == 2) $return .= '<span class="contact-seperator">'.$seperator.'</span>';
                if (custom_get_theme_option('address_2_'.$lang) && ($show == 'all' || $show == '2')) {
                    $return .= '<'.$l.' class="address-2">';
                    if (custom_get_theme_option('gmap_2_'.$lang)) $return .= '<a href="'.custom_get_theme_option('gmap_2_'.$lang).'" target="_blank">';
                    $return .= str_replace('|','<br>',custom_get_theme_option('address_2_'.$lang));
                    if (custom_get_theme_option('gmap_2_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
            $return .= '</'.$l.'>';
        $return .= '</'.$l.'>';
        
    }
    return $return;
}
add_shortcode('show_addresses', 'show_addresses');


function show_phones($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $phones = 0;
    if (custom_get_theme_option('phone_1_'.$lang)) $phones++; 
    if (custom_get_theme_option('phone_2_'.$lang)) $phones++; 
    if ($phones > 0) { 
        if ($inline) $l = 'span'; else $l = 'div';
        $return .= '<'.$l.' class="contact-data big-font phones';
            if ($icon) $return .= ' with-icon"><span class="contact-data-icon">'.do_shortcode('[icon_phone]').'</span>'; else  $return .= '">';
            if (!empty($label)) $return .= '<'.$l.' class="contact-data-title">'.$label.'</'.$l.'>';
            $return .= '<'.$l.' class="contact-data-info">';
                if (custom_get_theme_option('phone_1_'.$lang) && ($show == 'all' || $show == '1')) {
                    $return .= '<'.$l.' class="phone-1">';
                    $phone_link = str_replace('(','',custom_get_theme_option('phone_1_'.$lang));
                    $phone_link = str_replace(')','',$phone_link);
                    $phone_link = str_replace(' ','',$phone_link);
                    $phone_link = str_replace('+','00',$phone_link);
                    if (custom_get_theme_option('phone_1_'.$lang)) $return .= '<a href="tel:'.$phone_link.'" target="_blank">';
                    $return .= custom_get_theme_option('phone_1_'.$lang);
                    if (custom_get_theme_option('phone_1_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
                if ($phones == 2) $return .= '<span class="contact-seperator">'.$seperator.'</span>';
                if (custom_get_theme_option('phone_2_'.$lang) && ($show == 'all' || $show == '2')) {
                    $return .= '<'.$l.' class="phone-2">';
                    $phone_link = str_replace('(','',custom_get_theme_option('phone_2_'.$lang));
                    $phone_link = str_replace(')','',$phone_link);
                    $phone_link = str_replace(' ','',$phone_link);
                    $phone_link = str_replace('+','00',$phone_link);
                    if (custom_get_theme_option('phone_2_'.$lang)) $return .= '<a href="tel:'.$phone_link.'" target="_blank">';
                    $return .= custom_get_theme_option('phone_2_'.$lang);
                    if (custom_get_theme_option('phone_2_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
            $return .= '</'.$l.'>';
        $return .= '</'.$l.'>';
    }
    return $return;
}
add_shortcode('show_phones', 'show_phones');





function show_mobiles($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $mobiles = 0;
    if (custom_get_theme_option('mobile_1_'.$lang)) $mobiles++; 
    if (custom_get_theme_option('mobile_2_'.$lang)) $mobiles++; 
    if ($mobiles > 0) { 
        if ($inline) $l = 'span'; else $l = 'div';
        $return .= '<'.$l.' class="contact-data big-font mobiles';
            if ($icon) $return .= ' with-icon"><span class="contact-data-icon">'.do_shortcode('[icon_mobile]').'</span>'; else  $return .= '">';
            if (!empty($label)) $return .= '<'.$l.' class="contact-data-title">'.$label.'</'.$l.'>';
            $return .= '<'.$l.' class="contact-data-info">';
                if (custom_get_theme_option('mobile_1_'.$lang) && ($show == 'all' || $show == '1')) {
                    $return .= '<'.$l.' class="mobile-1">';
                    $mobile_link = str_replace('(','',custom_get_theme_option('mobile_1_'.$lang));
                    $mobile_link = str_replace(')','',$mobile_link);
                    $mobile_link = str_replace(' ','',$mobile_link);
                    $mobile_link = str_replace('+','00',$mobile_link);
                    if (custom_get_theme_option('mobile_1_'.$lang)) $return .= '<a href="tel:'.$mobile_link.'" target="_blank">';
                    $return .= custom_get_theme_option('mobile_1_'.$lang);
                    if (custom_get_theme_option('mobile_1_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
                if ($mobiles == 2) $return .= '<span class="contact-seperator">'.$seperator.'</span>';
                if (custom_get_theme_option('mobile_2_'.$lang) && ($show == 'all' || $show == '2')) {
                    $return .= '<'.$l.' class="mobile-2">';
                    $mobile_link = str_replace('(','',custom_get_theme_option('mobile_2_'.$lang));
                    $mobile_link = str_replace(')','',$mobile_link);
                    $mobile_link = str_replace(' ','',$mobile_link);
                    $mobile_link = str_replace('+','00',$mobile_link);
                    if (custom_get_theme_option('mobile_2_'.$lang)) $return .= '<a href="tel:'.$mobile_link.'" target="_blank">';
                    $return .= custom_get_theme_option('mobile_2_'.$lang);
                    if (custom_get_theme_option('mobile_2_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
            $return .= '</'.$l.'>';
        $return .= '</'.$l.'>';
    }
    return $return;
}
add_shortcode('show_mobiles', 'show_mobiles');




function show_phones_mobiles($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    
    
    $output = do_shortcode('[show_phones show="all" withicon="'.$icon.'" inline="'.$inline.'" seperator="'.$seperator.'" label="'.$label.'"]');
    $output .= do_shortcode('[show_mobiles show="all" withicon="'.$icon.'" inline="'.$inline.'" seperator="'.$seperator.'" label="'.$label.'"]');
    
    return $output;
}
add_shortcode('show_phones_mobiles', 'show_phones_mobiles');




function show_emails($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $emails = 0;
    if (custom_get_theme_option('email_1_'.$lang)) $emails++; 
    if (custom_get_theme_option('email_2_'.$lang)) $emails++; 
    if ($emails > 0) { 
        if ($inline) $l = 'span'; else $l = 'div';
        $return .= '<'.$l.' class="contact-data big-font emails';
            if ($icon) $return .= ' with-icon"><span class="contact-data-icon">'.do_shortcode('[icon_email]').'</span>'; else  $return .= '">';
            if (!empty($label)) $return .= '<'.$l.' class="contact-data-title">'.$label.'</'.$l.'>';
            $return .= '<'.$l.' class="contact-data-info">';
                if (custom_get_theme_option('email_1_'.$lang) && ($show == 'all' || $show == '1')) {
                    $return .= '<'.$l.' class="email-1">';
                    $email_link = custom_get_theme_option('email_1_'.$lang);
                    if (custom_get_theme_option('email_1_'.$lang)) $return .= '<a href="mailto:'.$email_link.'" target="_blank">';
                    $return .= custom_get_theme_option('email_1_'.$lang);
                    if (custom_get_theme_option('email_1_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
                if ($emails == 2) $return .= '<span class="contact-seperator">'.$seperator.'</span>';
                if (custom_get_theme_option('email_2_'.$lang) && ($show == 'all' || $show == '2')) {
                    $return .= '<'.$l.' class="email-2">';
                    $email_link = custom_get_theme_option('email_2_'.$lang);
                    if (custom_get_theme_option('email_2_'.$lang)) $return .= '<a href="mailto:'.$email_link.'" target="_blank">';
                    $return .= custom_get_theme_option('email_2_'.$lang);
                    if (custom_get_theme_option('email_2_'.$lang)) $return .= '</a>';
                    $return .= '</'.$l.'>';
                }
            $return .= '</'.$l.'>';
        $return .= '</'.$l.'>';
    }
    return $return;
}
add_shortcode('show_emails', 'show_emails');


function show_social($atts, $content = null) {
    $return = '';
    if (custom_get_theme_option('facebook') || custom_get_theme_option('instagram') || custom_get_theme_option('youtube') || custom_get_theme_option('twitter') || custom_get_theme_option('linkedin') || custom_get_theme_option('pinterest')) { 
        $return .= '<div class="contact-data big-font socials">';
            $return .= '<ul class="social-icons-list">';
                $svg = array();
                $svg['facebook'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="Group_97" data-name="Group 97" width="115.017" height="114.204" viewBox="0 0 115.017 114.204"> <g id="Group_90" data-name="Group 90" transform="translate(0 0)"> <g id="Group_89" data-name="Group 89" clip-path="url(#clip-path-2)"> <path id="Path_567" class="no-fill" data-name="Path 567" d="M86.86,43.659V33.089S62.395,27.626,62.395,47.1V57.529H52.419V68.658h9.857V99H75.7V68.658s8.908.237,8.908,0,1.781-11.129,1.781-11.129h-11.4S73.559,43.3,80.684,43.3A38.033,38.033,0,0,1,86.86,43.659Z" transform="translate(-15.171 -11.136)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3"/> </g> </g> </svg>';
                $svg['instagram'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="115.017" height="115.804" viewBox="0 0 115.017 115.804" style=""> <g id="Group_92" data-name="Group 92" transform="translate(0 0)"> <g id="Group_91" data-name="Group 91" clip-path="url(#clip-path-2)"> <path class="no-fill" id="Path_569" data-name="Path 569" d="M89.659,79.331A12.827,12.827,0,1,1,76.832,66.5,12.827,12.827,0,0,1,89.659,79.331Z" transform="translate(-23.32 -24.23)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3"/> <rect id="Rectangle_106" data-name="Rectangle 106" width="58.049" height="57.394" rx="13" transform="translate(24.169 25.875)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3"/> <ellipse id="Ellipse_5" data-name="Ellipse 5" cx="3.458" cy="3.458" rx="3.458" ry="3.458" transform="translate(66.955 34.479)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="3"/> </g> </g> </svg>';
                $svg['youtube'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <path d="M44,19H22.4c-4.6,0-8.4,3.8-8.4,8.4v12.2c0,4.6,3.8,8.4,8.4,8.4H44c4.6,0,8.4-3.8,8.4-8.4V27.4C52.4,22.8,48.6,19,44,19z M50.7,39.6c0,3.7-3,6.7-6.7,6.7H22.4c-3.7,0-6.7-3-6.7-6.7V27.4c0-3.7,3-6.7,6.7-6.7H44c3.7,0,6.7,3,6.7,6.7V39.6z"/> <path d="M29.8,26.8c-0.3-0.2-0.6-0.2-0.9,0c-0.3,0.2-0.4,0.4-0.4,0.8v12.3c0,0.3,0.2,0.6,0.5,0.8c0.1,0.1,0.3,0.1,0.4,0.1 c0.2,0,0.3,0,0.5-0.1l9.7-6.3c0.2-0.2,0.4-0.4,0.4-0.7c0-0.3-0.2-0.6-0.4-0.7L29.8,26.8z M30.2,38.2V29l7.2,4.5L30.2,38.2z"/> </g> </svg>';
                $svg['tiktok'] = '<svg xmlns="http://www.w3.org/2000/svg" fill="#000000" width="800px" height="800px" viewBox="0 0 512 512" id="icons"><path d="M412.19,118.66a109.27,109.27,0,0,1-9.45-5.5,132.87,132.87,0,0,1-24.27-20.62c-18.1-20.71-24.86-41.72-27.35-56.43h.1C349.14,23.9,350,16,350.13,16H267.69V334.78c0,4.28,0,8.51-.18,12.69,0,.52-.05,1-.08,1.56,0,.23,0,.47-.05.71,0,.06,0,.12,0,.18a70,70,0,0,1-35.22,55.56,68.8,68.8,0,0,1-34.11,9c-38.41,0-69.54-31.32-69.54-70s31.13-70,69.54-70a68.9,68.9,0,0,1,21.41,3.39l.1-83.94a153.14,153.14,0,0,0-118,34.52,161.79,161.79,0,0,0-35.3,43.53c-3.48,6-16.61,30.11-18.2,69.24-1,22.21,5.67,45.22,8.85,54.73v.2c2,5.6,9.75,24.71,22.38,40.82A167.53,167.53,0,0,0,115,470.66v-.2l.2.2C155.11,497.78,199.36,496,199.36,496c7.66-.31,33.32,0,62.46-13.81,32.32-15.31,50.72-38.12,50.72-38.12a158.46,158.46,0,0,0,27.64-45.93c7.46-19.61,9.95-43.13,9.95-52.53V176.49c1,.6,14.32,9.41,14.32,9.41s19.19,12.3,49.13,20.31c21.48,5.7,50.42,6.9,50.42,6.9V131.27C453.86,132.37,433.27,129.17,412.19,118.66Z"/></svg>';
                $svg['twitter'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <path d="M32.2,28.4c-2.2,0-7.9-0.8-14.7-7.4c-0.6,0.9-1.3,2.6,0,4.7c0.3,0.4,0.1,0.9-0.3,1.2c-0.4,0.3-0.9,0.1-1.2-0.3 c-2.1-3.4-0.4-6.4,0.8-7.5c0.3-0.3,0.9-0.3,1.2,0c6.5,6.7,12,7.5,14,7.5c-0.1-1.7,0.1-5.1,3.5-7.9c4.1-3.2,9.6,0.1,11.2,1.2 l4.6-2.2c0.4-0.2,0.8-0.1,1,0.2c0.3,0.3,0.3,0.7,0,1.1L49,23.8c-0.3,0.4-0.8,0.5-1.2,0.2c-0.4-0.3-0.5-0.8-0.2-1.2l1.5-2l-2,0.9 c-0.3,0.1-0.6,0.1-0.9-0.1c-0.1,0-5.8-4.4-9.5-1.5c-3.7,3-2.8,6.9-2.8,7.1c0.1,0.2,0,0.5-0.1,0.7c-0.1,0.2-0.3,0.3-0.6,0.4 C33.1,28.3,32.8,28.4,32.2,28.4z"/> <path d="M17.7,35.1c-0.2,0-0.4-0.1-0.6-0.2c-2.2-2.2-2.1-5.8-2.1-6c0-0.3,0.2-0.5,0.4-0.7c0.2-0.1,0.5-0.2,0.8-0.1l3.6,1.5 c0.4,0.2,0.6,0.7,0.5,1.1c-0.2,0.4-0.7,0.6-1.1,0.5l-2.3-1c0.1,1,0.5,2.4,1.5,3.3c0.3,0.3,0.3,0.9,0,1.2 C18.1,35.1,17.9,35.1,17.7,35.1z"/> <path d="M22.7,42.2c-0.1,0-0.3,0-0.4-0.1c-4.4-2.3-4.8-5-4.8-5.3c0-0.2,0.1-0.5,0.2-0.7c0.2-0.2,0.4-0.3,0.6-0.3h4.4 c0.5,0,0.9,0.4,0.9,0.9s-0.4,0.9-0.9,0.9h-3.1c0.5,0.8,1.5,1.9,3.5,3c0.4,0.2,0.6,0.7,0.4,1.2C23.3,42.1,23,42.2,22.7,42.2z"/> <path d="M29.2,49.6c-7.6,0-14.5-3.6-14.9-3.8c-0.4-0.2-0.6-0.6-0.4-1c0.1-0.4,0.5-0.6,1-0.6c6.4,1.2,10-2.4,10.2-2.6 c0.3-0.3,0.9-0.3,1.2,0c0.3,0.3,0.3,0.9,0,1.2c-0.1,0.1-2.6,2.6-6.9,3.2c4.6,1.6,12.1,3.2,18.2-0.1c5.6-3,8.9-9.5,9.9-19.3 c0-0.5,0.5-0.8,0.9-0.8c0.5,0,0.8,0.5,0.8,0.9c-1.1,10.4-4.7,17.3-10.9,20.6C35.4,49,32.2,49.6,29.2,49.6z"/> </g> </svg>';
                $svg['linkedin'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <g> <circle cx="23.1" cy="36.4" r="2.3"/> <circle cx="42.9" cy="36.3" r="2.3"/> <path d="M55.9,25.1c0,0-4.4,0.2-8.5,0.4c-1.4-1.6-6-5.9-14.2-5.8c-9,0.1-12.5,4.8-13.2,5.8c-4.3-0.3-9.4-0.5-9.4-0.5l4.4,4.6 c-1.5,1.8-2.4,4.1-2.4,6.7c0,5.8,4.7,10.5,10.5,10.5c3.2,0,6.1-1.5,8-3.7l2,4.1l2-3.9c1.9,2.1,4.7,3.5,7.8,3.5 c5.8,0,10.5-4.7,10.5-10.5c0-2.4-0.8-4.6-2.2-6.4L55.9,25.1z M33.2,21.4c0,0,0.1,0,0.1,0c5.9,0,9.8,2.5,11.7,4.2 c-0.6,0-1.1,0.1-1.6,0.1c-0.2,0-0.3,0-0.5,0c-4.6,0-8.5,3-9.9,7.1c-1.2-3.4-4.1-6-7.7-6.7l0.1,0c-0.4-0.1-1.7-0.3-3.4-0.4 C23.3,24.2,26.6,21.5,33.2,21.4z M23.1,45.2c-4.9,0-8.8-4-8.8-8.8c0-4.9,4-8.8,8.8-8.8c4.9,0,8.8,4,8.8,8.8 C31.9,41.2,28,45.2,23.1,45.2z M42.9,45.1c-4.9,0-8.8-4-8.8-8.8c0-4.9,4-8.8,8.8-8.8c4.9,0,8.8,4,8.8,8.8 C51.8,41.1,47.8,45.1,42.9,45.1z"/> </g> </svg>';
                $svg['pinterest'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <path d="M47.6,25.2c-1.5-5.1-6-9.1-9.4-10c-5.8-1.5-15.8,0-19,8.2c-3.2,8.2,2.2,12.3,2.2,12.3c0.4,0.3,0.9,0.2,1.2-0.2 c0.3-0.4,0.2-0.9-0.2-1.2c-0.2-0.1-4.4-3.4-1.7-10.3c2.7-6.9,11.6-8.6,17-7.1c2.9,0.8,6.8,4.4,8.2,8.9c0.8,2.6,0.9,6.5-2.6,10.4 c-2,2.2-4.2,3.3-6.5,3.3c0,0,0,0,0,0c-3.5,0-6.5-2.6-7.4-3.5l2.8-11.6c0.1-0.5-0.2-0.9-0.6-1c-0.5-0.1-0.9,0.2-1,0.6L24,51.3 c-0.1,0.5,0.2,0.9,0.6,1c0.1,0,0.1,0,0.2,0c0.4,0,0.7-0.3,0.8-0.7l3.3-13.9c1.5,1.3,4.4,3.3,7.8,3.3c0,0,0,0,0,0 c2.8,0,5.4-1.3,7.7-3.9C48.7,32.7,48.5,28.2,47.6,25.2z"/> </svg>';
                $svg['tripadvisor'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 66.4 67" style="enable-background:new 0 0 66.4 67;" xml:space="preserve"> <path d="M47.6,25.2c-1.5-5.1-6-9.1-9.4-10c-5.8-1.5-15.8,0-19,8.2c-3.2,8.2,2.2,12.3,2.2,12.3c0.4,0.3,0.9,0.2,1.2-0.2 c0.3-0.4,0.2-0.9-0.2-1.2c-0.2-0.1-4.4-3.4-1.7-10.3c2.7-6.9,11.6-8.6,17-7.1c2.9,0.8,6.8,4.4,8.2,8.9c0.8,2.6,0.9,6.5-2.6,10.4 c-2,2.2-4.2,3.3-6.5,3.3c0,0,0,0,0,0c-3.5,0-6.5-2.6-7.4-3.5l2.8-11.6c0.1-0.5-0.2-0.9-0.6-1c-0.5-0.1-0.9,0.2-1,0.6L24,51.3 c-0.1,0.5,0.2,0.9,0.6,1c0.1,0,0.1,0,0.2,0c0.4,0,0.7-0.3,0.8-0.7l3.3-13.9c1.5,1.3,4.4,3.3,7.8,3.3c0,0,0,0,0,0 c2.8,0,5.4-1.3,7.7-3.9C48.7,32.7,48.5,28.2,47.6,25.2z"/> </svg>';
                $value_pos = custom_get_theme_option( 'social_pos' );
                $positions = array();
                if (!empty($value_pos)) {
                    foreach ($value_pos as $soc=>$pos) {
                        $positions[$pos] = $soc;
                    }
                }
                ksort($positions);
                foreach ($positions as $icon) {
                    if (custom_get_theme_option($icon)) {
                        $return .= '<li class="social-icon '.$icon.'"><a href="'.custom_get_theme_option($icon).'" aria-label="'.$icon.'" target="_blank">'.$svg[$icon].'</a></li>';
                    }
                }
            $return .= '</ul>';
        $return .= '</div>';
    }
    return $return;
}
add_shortcode('show_social', 'show_social');


function show_working_hours($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $return = '';
    if (custom_get_theme_option('monday') || custom_get_theme_option('tuesday') || custom_get_theme_option('wednesday') || custom_get_theme_option('thursday') || custom_get_theme_option('friday') || custom_get_theme_option('saturday') || custom_get_theme_option('sunday') || custom_get_theme_option('friday') || custom_get_theme_option('days_1_name_'.$lang) || custom_get_theme_option('days_2_name_'.$lang) || custom_get_theme_option('days_3_name_'.$lang)) { 
        $return .= '<div class="contact-data big-font working-hours';
            if ($icon) $return .= ' with-icon"><span class="contact-data-icon">'.do_shortcode('[icon_clock]').'</span>'; else  $return .= '">';
            $return .= '<table class="working-hours-list">';
                if (custom_get_theme_option('monday')) $return .= '<tr><td class="working-day">'.__("Monday").'</td><td class="working-hour">'.custom_get_theme_option('monday').'</td></tr>';
                if (custom_get_theme_option('tuesday')) $return .= '<tr><td class="working-day">'.__("Tuesday").'</td><td class="working-hour">'.custom_get_theme_option('tuesday').'</td></tr>';
                if (custom_get_theme_option('wednesday')) $return .= '<tr><td class="working-day">'.__("Wednesday").'</td><td class="working-hour">'.custom_get_theme_option('wednesday').'</td></tr>';
                if (custom_get_theme_option('thursday')) $return .= '<tr><td class="working-day">'.__("Thursday").'</td><td class="working-hour">'.custom_get_theme_option('thursday').'</td></tr>';
                if (custom_get_theme_option('friday')) $return .= '<tr><td class="working-day">'.__("Friday").'</td><td class="working-hour">'.custom_get_theme_option('friday').'</td></tr>';
                if (custom_get_theme_option('saturday')) $return .= '<tr><td class="working-day">'.__("Saturday").'</td><td class="working-hour">'.custom_get_theme_option('saturday').'</td></tr>';
                if (custom_get_theme_option('sunday')) $return .= '<tr><td class="working-day">'.__("Sunday").'</td><td class="working-hour">'.custom_get_theme_option('sunday').'</td></tr>';
                if (custom_get_theme_option('days_1_name_'.$lang)) $return .= '<tr><td class="working-day">'.custom_get_theme_option('days_1_name_'.$lang).'</td><td class="working-hour">'.custom_get_theme_option('days_1_val_'.$lang).'</td></tr>';
                if (custom_get_theme_option('days_2_name_'.$lang)) $return .= '<tr><td class="working-day">'.custom_get_theme_option('days_2_name_'.$lang).'</td><td class="working-hour">'.custom_get_theme_option('days_2_val_'.$lang).'</td></tr>';
                if (custom_get_theme_option('days_3_name_'.$lang)) $return .= '<tr><td class="working-day">'.custom_get_theme_option('days_3_name_'.$lang).'</td><td class="working-hour">'.custom_get_theme_option('days_3_val_'.$lang).'</td></tr>';
            $return .= '</table>';
        $return .= '</div>';
    }
    return $return;
}
add_shortcode('show_working_hours', 'show_working_hours');






function show_iframes($atts, $content = null) {
    $lang = apply_filters( 'wpml_current_language', NULL );
    $a = shortcode_atts( array(
        'show' => 'all',
        'withicon' => false,
        'inline'  =>  false, 
        'seperator' => ',',
        'label' => ''
    ), $atts );
    $return = '';
    $show = $a['show'];
    $icon = $a['withicon'];
    $inline = $a['inline'];
    $seperator = $a['seperator'];
    $label = $a['label'];
    $return = '';
    $iframes = 0;
    if (custom_get_theme_option('iframe_1_'.$lang)) $iframes++; 
    if (custom_get_theme_option('iframe_2_'.$lang)) $iframes++; 
    if ($iframes > 0) { 
        if ($inline) $l = 'span'; else $l = 'div';
        $return .= '<'.$l.' class="contact-data big-font iframes">';
        
            if (!empty($label)) $return .= '<'.$l.' class="contact-data-title">'.$label.'</'.$l.'>';
            $return .= '<'.$l.' class="contact-data-info">';
                if (custom_get_theme_option('iframe_1_'.$lang) && ($show == 'all' || $show == '1')) {
                    $return .= '<'.$l.' class="iframe-1">';
                    $return .= custom_get_theme_option('iframe_1_'.$lang);
                    $return .= '</'.$l.'>';
                }
                if (custom_get_theme_option('iframe_2_'.$lang) && ($show == 'all' || $show == '2')) {
                    $return .= '<'.$l.' class="iframe-2">';
                    $return .= custom_get_theme_option('iframe_2_'.$lang);
                    $return .= '</'.$l.'>';
                }
            $return .= '</'.$l.'>';
        $return .= '</'.$l.'>';
    }
    return $return;
}
add_shortcode('show_iframes', 'show_iframes');


function data_to_preview() {
    ?>
    
    <script>
        jQuery( document ).ready(function($) {
            $("body").on('mouseenter', 'button.components-button.block-editor-block-types-list__item.editor-block-list-item-ink-gutenberg-room-section-block', function() {
                $(".block-editor-inserter__preview-container").addClass("theme-data");
            });
            $("body").on('mouseleave', 'button.components-button.block-editor-block-types-list__item.editor-block-list-item-ink-gutenberg-room-section-block', function() {
                $(".block-editor-inserter__preview-container").removeClass("theme-data");
            });
        });
    </script>
    <?php 
}
add_action('admin_footer','data_to_preview');