(function(blocks, components, i18n, element) {

    var el = element.createElement;
    
    const iconEl = el(
        'svg', {  
            height: 20,
            style: {
                backgroundColor: "#89c648" 
            }
        },
        /*
        el('text', { 
            x: 0,
            y: 14,
            fill: '#fff',
            style: {
                fontSize: "9px" 
            }
            }, 'ΑΦΗΣ' 
        )
        */
    );
    
    function Level(name, code)
    {
       this.name = name;
       this.code = code;
    } 

    blocks.registerBlockType('ink-gutenberg/room-section-block', {
        title: 'Theme Data', 
        keywords: ['INK', 'Design', 'custom', 'theme', 'ΑΦΗΣ', 'Αφής', 'αφής', 'AFIS', 'Afis', 'afis', 'data', 'default', 'shortcode', 'contact', 'phone', 'mobile', 'email', 'social', 'iframe'],
        icon: iconEl, 
        category: 'common', 
        attributes: { 
            themeShortcodes: {
                type: 'string',
                selector: 'select.shortcode',
            }, 
            showhide: {
                type: 'string',
                default: '1',
            }, 
            iconCheckbox: {
                type: 'boolean',
                selector: 'input.icon-checkobx'
            }, 
            setInline: {
                type: 'boolean',
                selector: 'input.setinline-checkobx'
            },
            seperator: {
                type: 'string',
                default: ', '
            },
            labelator: {
                type: 'string'
            }
        },
        
        
        
        
        edit: function(props) {
            
            function updateShowHide(event) {
                props.setAttributes({showhide: event.target.value})
            }
            
            function updateWithIcon(event) {
                props.setAttributes({iconCheckbox: event.target.checked})
            }
            
            
            function updateSetInline(event) {
                props.setAttributes({setInline: event.target.checked})
            }
            
            function updateThemeShortcodes(newdata) {
                props.setAttributes({
                    themeShortcodes: newdata.target.value
                });
            }
            
            function updateSeperator(event) {
                props.setAttributes({seperator: event.target.value})
            }
            
            function updateLabelator(event) {
                props.setAttributes({labelator: event.target.value})
            }
            
            
            var random = Math.floor((Math.random() * 100000) + 1);
            options = [
                new Level("Show all addresses", "show_all_addresses"),
                new Level("Show address 1", "show_address_1"),
                new Level("Show address 2", "show_address_2"),
                new Level("Show all phones & mobiles", "show_all_phones_mobiles"),
                new Level("Show all phones", "show_all_phones"),
                new Level("Show phone 1", "show_phone_1"),
                new Level("Show phone 2", "show_phone_2"),
                new Level("Show all mobiles", "show_all_mobiles"),
                new Level("Show mobile 1", "show_mobile_1"),
                new Level("Show mobile 2", "show_mobile_2"),
                new Level("Show all emails", "show_all_emails"),
                new Level("Show email 1", "show_email_1"),
                new Level("Show email 2", "show_email_2"),
                new Level("Show iframe 1", "show_ifram_1"),
                new Level("Show iframe 2", "show_ifram_2"),
                new Level("Show working hours", "show_working_hours"),
                new Level("Show Social", "show_social")
            ];

            return React.createElement(
                    "div", { 
                        className: props.attributes.showhide > 0  ? "inkdesign-block" : "inkdesign-block ink-disabled",
                        id: "inkdesign-block-id-"+random
                    },
                    React.createElement( "h4", {style: { margin: "0" }}, "Theme Data" ),
                    React.createElement(
                        "select", {
                            value: props.attributes.themeShortcodes, 
                            onChange: updateThemeShortcodes,
                        }, 
                        options.map((item,i) => React.createElement("option", {key:i, value:item.code},item.name))
                    ),
                    
                    React.createElement( "div", {style: { display: "inline", margin: "0 15px" }},
                        React.createElement( 
                            "input", { 
                                id: "icon"+random,
                                type: "checkbox", 
                                defaultChecked: props.attributes.iconCheckbox, 
                                onChange: updateWithIcon, 
                            }
                        ),
                        React.createElement( "label", {for: "icon"+random, style: { margin: "0" }}, "with icon" )
                    ),

                    
                    React.createElement( "div", {style: { display: "inline" }},
                        React.createElement( 
                            "input", { 
                                id: "setinline"+random,
                                type: "checkbox", 
                                defaultChecked: props.attributes.setInline, 
                                onChange: updateSetInline, 
                            }
                        ),
                        React.createElement( "label", {for: "setinline"+random, style: { margin: "0" }}, "set inline to text" )
                    ),
                    
                    React.createElement( "div", {style: { display: "block" }},
                        React.createElement( "p", {style: { display: "inline", fontSize:"14px" }}, "Seperator for all choices. Default comma(, )" ),
                        React.createElement( 
                            "input", { 
                                placeholder: "Seperator",
                                type: "text", 
                                value: props.attributes.seperator, 
                                onChange: updateSeperator, 
                            }
                        ),
                        React.createElement( 
                            "input", { 
                                placeholder: "Label before data",
                                type: "text", 
                                value: props.attributes.labelator, 
                                onChange: updateLabelator, 
                            }
                        )
                    )

      
            );
                   

        }, // End edit()
        
        

        save: function(props) {
            
            return '[theme_shortcode shortcode="'+props.attributes.themeShortcodes+'" withicon="'+props.attributes.iconCheckbox+'" inline="'+props.attributes.setInline+'" seperator="'+props.attributes.seperator+'" label="'+props.attributes.labelator+'"]';
           
        }
        
        
    });
    
    
    
    
})(
    window.wp.blocks,
    window.wp.components,
    window.wp.i18n,
    window.wp.element
);