jQuery(document).ready(function($){

    // Instantiates the variable that holds the media library frame.
    var meta_image_frame;
    var meta_icon_frame;
    var meta_icon_frame_home;

    // Runs when the image button is clicked.
    $('#upload_image_btn').click(function(e){

        // Prevents the default action from occuring.
        e.preventDefault();

        // If the frame already exists, re-open it.
        if ( meta_image_frame ) {
            meta_image_frame.open();
            return;
        }

        // Sets up the media library frame
        meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
            title: 'Upload Image',
            button: { text:  'Use this image' },
            library: { type: 'image' }
        });

        // Runs when an image is selected.
        meta_image_frame.on('select', function(){

            // Grabs the attachment selection and creates a JSON representation of the model.
            var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

            // Sends the attachment URL to our custom image input field.
            $('#bg_img').val(media_attachment.url);
            $('#bg_img_url').attr('src',media_attachment.url);
        });

        // Opens the media library frame.
        meta_image_frame.open();
    });

    $('#delete_image_btn').click(function(e){
        // Prevents the default action from occuring.
        e.preventDefault();
        $('#bg_img').val('');
        $('#bg_img_url').attr('src',''); 
    });


    // Runs when the image button is clicked.
    $('#upload_icon_btn').click(function(e){
        // Prevents the default action from occuring.
        e.preventDefault();
        
        // If the frame already exists, re-open it.
        if ( meta_icon_frame ) {
            meta_icon_frame.open();
            return;
        }

        // Sets up the media library frame
        meta_icon_frame = wp.media.frames.meta_icon_frame = wp.media({
            title: meta_image.title,
            button: { text:  meta_image.button },
            library: { type: 'image' }
        });
        
        // Runs when an image is selected.
        meta_icon_frame.on('select', function(){

            // Grabs the attachment selection and creates a JSON representation of the model.
            var media_attachment = meta_icon_frame.state().get('selection').first().toJSON();

            // Sends the home_upload_image URL to our custom image input field.
            $('#bg_icon').val(media_attachment.url);
            $('#bg_icon_url').attr('src',media_attachment.url);
        });

        // Opens the media library frame.
        meta_icon_frame.open();
        
    });
    
    $('#delete_icon_btn').click(function(e){
        // Prevents the default action from occuring.
        e.preventDefault();
        $('#bg_icon').val('');
        $('#bg_icon_url').attr('src','');
    });


    // Runs when the image button is clicked.
    $('#upload_icon_home_btn').click(function(e){
        // Prevents the default action from occuring.
        e.preventDefault();
        
        // If the frame already exists, re-open it.
        if ( meta_icon_frame_home ) {
            meta_icon_frame_home.open();
            return;
        }

        // Sets up the media library frame
        meta_icon_frame_home = wp.media.frames.meta_icon_frame_home = wp.media({
            title: meta_image.title,
            button: { text:  meta_image.button },
            library: { type: 'image' }
        });
        
        // Runs when an image is selected.
        meta_icon_frame_home.on('select', function(){

            // Grabs the attachment selection and creates a JSON representation of the model.
            var media_attachment = meta_icon_frame_home.state().get('selection').first().toJSON();

            // Sends the home_upload_image URL to our custom image input field.
            $('#bg_icon_home').val(media_attachment.url);
            $('#bg_icon_home_url').attr('src',media_attachment.url);
        });

        // Opens the media library frame.
        meta_icon_frame_home.open();
        
    });
    
    $('#delete_icon_home_btn').click(function(e){
        // Prevents the default action from occuring.
        e.preventDefault();
        $('#bg_icon_home').val('');
        $('#bg_icon_home_url').attr('src',''); 
    });

});