(function( root, $, undefined ) {
	"use strict";

	$(function () {
		$(document).foundation();
		window.onbeforeunload = function () {
          window.scrollTo(0, 0);
        }

        $('.counter').counterUp({
          delay: 10,
          time: 2000,
          triggerOnce: true 
        });
        
        $(".project-gallery .gallery br").each(function(e){
            $(this).remove(); 
        });
		
		$( ".submenu-toggle" ).each(function() {
            var buttonID = $( this ).attr('id');
            var newButtonID = 'button-'+buttonID;
             $( this ).attr('id', newButtonID);
        });
        var mouseX = 0, mouseY = 0;
        var xp = 0, yp = 0;
         
        $(document).mousemove(function(e){
            mouseX = e.pageX - 20;
            mouseY = e.pageY - 20; 
        });
            
        setInterval(function(){
            xp += ((mouseX - xp)/6);
            yp += ((mouseY - yp)/6);
            $(".cursor").css({left: xp +'px', top: yp +'px'});
        }, 20);
        
            $( "a, .slick-arrow" ).hover(
                function() {
                    $(".cursor").addClass("hover");
                }, function() {
                    $(".cursor").removeClass("hover");
                }
            );
        
        
        
        $("a").click(function(e){
            var href = $(this).attr("href");
            if (href.includes("#")) {
                e.preventDefault();
                if ($(href).length) {
                    $('html, body').animate({
                        scrollTop: $(href).offset().top
                    }, 500);
                }
            }
        });
        
        
        $('#inner-links a[href^="#"]').click(function(e){
            $('#inner-links a').each(function(){
                $(this).parent().removeClass('active'); 
            });
            
            $(this).parent().addClass('active');
            var href = $(this).attr("href").split('#')[1];
            href = 'is-'+href;
            $("#inner-output-links .wp-block-group").each(function(){
                if (href == 'is-all') {
                    $(this).removeClass("visibility-on");
                    $(this).removeClass("visibility-off");
                } else if ($(this).attr('id') == href) {
                    $(this).addClass("visibility-on");
                    $(this).removeClass("visibility-off");
                } else {
                    $(this).addClass("visibility-off");
                    $(this).removeClass("visibility-on");
                }
            });
        });
        
        $(".wp-block-cover .wp-block-cover__inner-container, .wp-block-cover-image .wp-block-cover__inner-container, .main-footer-block .widget_block, .social-icons-list").each(function(){
            var children = $(this).children().length;
            $(this).addClass("has-block-children-"+children);
        });
        
        
        
        scrolling();
        $(window).on('DOMContentLoaded load resize scroll mousewheel DOMMouseScroll wheel', function(){
			
			scrolling();
		});
		
        function scrolling() {
            var scrollTopReal = $(window).scrollTop();
            var scrollTopEnd = $(window).scrollTop() + $(window).height();
            var scrollTop = $(window).scrollTop() + $(window).height()/2;
            if ($(window).width() > 1024) {
                $(".thumbnail-of-port-top, .the-content > .wp-block-cover, .main-footer-container, .top-footer-container, .latest-projects-section ").each(function(e){
                    var classnmae = $(this).attr('class');
                    var scrollCover = $(this).offset().top;
                    var endCover = scrollCover + $(window).height();
                    var logoScroll = scrollTopReal+50;
                    var langScroll = scrollTopReal+150;
                    var menuScroll = scrollCover + $(window).height()/2;
                    
                    if (scrollCover < scrollTop && scrollTop < endCover) {
                        if ($(this).hasClass('has-white-color')) {
                            $(".mobile-menu-link").removeClass('make-it-black');
                            $(".mobile-menu-link").addClass('make-it-white');
                            
                        } else if ($(this).hasClass('has-black-color')) {
                            $(".mobile-menu-link").removeClass('make-it-white');
                            $(".mobile-menu-link").addClass('make-it-black');
                        } else {
                            $(".mobile-menu-link").removeClass('make-it-black');
                            $(".mobile-menu-link").removeClass('make-it-white');
                        }
                        
                    }
                    
                    
                    if (logoScroll > scrollCover) {
                        if ($(this).hasClass('has-white-color')) {
                            $("#airtec-logo").removeClass('make-it-black');
                            $("#airtec-logo").addClass('make-it-white');
                            
                        } else if ($(this).hasClass('has-black-color')) {
                            $("#airtec-logo").removeClass('make-it-white');
                            $("#airtec-logo").addClass('make-it-black');
                        } else {
                            $("#airtec-logo").removeClass('make-it-black');
                            $("#airtec-logo").removeClass('make-it-white');
                        }
                    }
                    
                    if (langScroll > scrollCover) {
                        if ($(this).hasClass('has-white-color')) {
                            $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-black');
                            $(".wpml-ls-legacy-list-horizontal").addClass('make-it-white');
                            
                        } else if ($(this).hasClass('has-black-color')) {
                            $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-white');
                            $(".wpml-ls-legacy-list-horizontal").addClass('make-it-black');
                        } else {
                            $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-black');
                            $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-white');
                        }
                    }
                    
                        $(".mobile-menu").removeClass('has-been-white');
                });
            } else {
                $(".should-be-full-height").each(function(e){
                    $(this).removeClass("should-be-full-height"); 
                });
                
                $("ul.wp-block-list.hide-for-large").each(function(){
                    var parentHtml = $(this).parent().html(); 
                    var select = 'select';
                    if (!$(this).hasClass('inner-links')) select = 'select  onchange="location = this.value;"'
                    var parentHtmlNew = parentHtml.replace(new RegExp('ul', 'g'),select);
                    var parentHtmlNewli = parentHtmlNew.replace(new RegExp('<li>', 'g'),'');
                    var parentHtmlNewli1 = parentHtmlNewli.replace(new RegExp('</li>', 'g'),'');
                    var parentHtmlNewlia = parentHtmlNewli1.replace(new RegExp('<a href', 'g'),'<option value');
                    var parentHtmlNewlia1 = parentHtmlNewlia.replace(new RegExp('</a>', 'g'),'</option>');
                    
                    $(this).parent().html(parentHtmlNewlia1);
                    
                });
                
                if (scrollTopReal > 50) {
                    $("body:has( .featured-container) .mobile-menu").addClass('has-been-white');
                        $("#airtec-logo").removeClass('make-it-black');
                        $("#airtec-logo").removeClass('make-it-white');
                        $(".mobile-menu-link").removeClass('make-it-black');
                        $(".mobile-menu-link").removeClass('make-it-white');
                }
                else {
                    $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-black');
                    $(".wpml-ls-legacy-list-horizontal").removeClass('make-it-white');
                    if ($(".featured-container").length) {
                        $(".mobile-menu").removeClass('has-been-white');
                        $("#airtec-logo").addClass('make-it-white');
                        $(".mobile-menu-link").addClass('make-it-white');
                    }
                    else {
                        $("#airtec-logo").removeClass('make-it-black');
                        $("#airtec-logo").removeClass('make-it-white');
                        $(".mobile-menu-link").removeClass('make-it-black');
                        $(".mobile-menu-link").removeClass('make-it-white');
                    }
                }
            }
            
            $('*[class*="has-block-children"], .latest-projects').children().each(function(){
                var blockChildrenTop = $(this).offset().top;
                if (scrollTop > blockChildrenTop) {
                    $(this).addClass("show-borders");
                }
            });
        }
        
        $('.slider-list').slick({
			infinite: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			dots: false,
			arrows:true,
			autoplay: true,
	        autoplaySpeed: 3000,
	        fade: true,
	        cssEase: 'linear',
	        
	        prevArrow: '<a class="slick-arrow slick-prev"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M0.292893 7.29289C-0.0976295 7.68341 -0.0976296 8.31658 0.292892 8.7071L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34314C8.46159 1.95262 8.46159 1.31945 8.07107 0.92893C7.68054 0.538406 7.04738 0.538405 6.65686 0.92893L0.292893 7.29289ZM34 7L1 7L1 9L34 9L34 7Z" fill="white"/> </svg></a>',
	        nextArrow: '<a class="slick-arrow slick-next"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M33.7071 8.70711C34.0976 8.31658 34.0976 7.68342 33.7071 7.29289L27.3431 0.928932C26.9526 0.538408 26.3195 0.538408 25.9289 0.928932C25.5384 1.31946 25.5384 1.95262 25.9289 2.34315L31.5858 8L25.9289 13.6569C25.5384 14.0474 25.5384 14.6805 25.9289 15.0711C26.3195 15.4616 26.9526 15.4616 27.3431 15.0711L33.7071 8.70711ZM0 9H33V7H0V9Z" fill="white"/> </svg></a>',
	        pauseOnHover:false,
			responsive: [ 
				{
				  breakpoint: 1024,
				  settings: {
					slidesToShow: 1,
					slidesToScroll: 1,
					infinite: true,
					dots: false
				  }
				},
				{
				  breakpoint: 600,
				  settings: {
					slidesToShow: 1,
					slidesToScroll: 1
				  }
				},
				{
				  breakpoint: 480,
				  settings: {
					slidesToShow: 1,
					slidesToScroll: 1
				  }
				}
			  ]
		  });
        function animationsInit() {
		      if ($(window).width() < 640) {
		          var left = "fade-in";
		          var right = 'fade-in';
		      } else {
		          left = "fade-left";
		          right = 'fade-right';
		      }
		      $('.fade-left').each(function(){
		          $(this).addClass('aos-init');
		          $(this).attr('data-aos', left);
		          $(this).attr('data-aos-delay', '600');
		      });
		      $('.fade-right').each(function(){
		          $(this).addClass('aos-init');
		          $(this).attr('data-aos', right);
		          $(this).attr('data-aos-delay', '600');
		      });
		      $('.fade-in').each(function(){
		          $(this).addClass('aos-init');
		          $(this).attr('data-aos', 'fade-in');
		          $(this).attr('data-aos-delay', '600');
		      });
		      $('*[class*="fade-delay"]').each(function(){
		          var getClass = $(this).attr('class');
		          var split1 = getClass.split('fade-delay-');
		          var keeep = split1[1];
		          var split2 = keeep.split(' ');
		          var time = split2[0];
		          $(this).attr('data-aos-delay', time);
		      });
		      $('*[class*="max-width"]').each(function(){
		          var getClass = $(this).attr('class');
		          var split1 = getClass.split('max-width-');
		          var keeep = split1[1];
		          var split2 = keeep.split(' ');
		          var css = split2[0];
		          $(this).css('max-width', css+'px');
		      });
		      $(".wp-block-image.abs").each(function(){
		            var width = $(this).find('img').attr('width');
		            $(this).width(width);
		      });
		      
		      
		  }
		  
		  animationsInit();
		  $(window).resize(function(){
		      animationsInit();
		  });
        
        
        $('.wp-block-gallery, .project-gallery .gallery').each(function(e){
            var galleryNo = Math.floor(Math.random() * 10);
            var lightbox = 'gallery-'+galleryNo;
            $(this).find('a').each(function(e){
                $(this).attr('data-lightbox',lightbox); 
            });
        });
        
        
        $("ul.accordion.off-canvas-nav li:not(.open-submenu) a").click(function(e){
            e.preventDefault();
            var href = $(this).attr('href');
            $(".js-off-canvas-overlay").trigger('click');
            setTimeout(function(){
                window.location.href = href;
            },150)
        });
        		
        $(".open-submenu > a").click(function(e){
            e.preventDefault();
            $(this).parent().find('button').trigger('click');
        });
        
        
        if ($(window).width > 1024) {
            $( ".open-submenu" ).hover(
              function() {
                $(this).find('button[aria-expanded="false"]').trigger('click');
              }, function() {
                $(this).find('button[aria-expanded="true"]').trigger('click');
              }
            );
        }
        
		
		$('.latest-projects').slick({
			infinite: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			dots: false,
			arrow: true,
	        /*
			autoplay: true,
            autoplaySpeed: 2000,
	        fade: true,
	        cssEase: 'linear',
	        */
	        prevArrow: '<a class="slick-arrow slick-prev"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M0.292893 7.29289C-0.0976295 7.68341 -0.0976296 8.31658 0.292892 8.7071L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34314C8.46159 1.95262 8.46159 1.31945 8.07107 0.92893C7.68054 0.538406 7.04738 0.538405 6.65686 0.92893L0.292893 7.29289ZM34 7L1 7L1 9L34 9L34 7Z" fill="white"/> </svg></a>',
	        nextArrow: '<a class="slick-arrow slick-next"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M33.7071 8.70711C34.0976 8.31658 34.0976 7.68342 33.7071 7.29289L27.3431 0.928932C26.9526 0.538408 26.3195 0.538408 25.9289 0.928932C25.5384 1.31946 25.5384 1.95262 25.9289 2.34315L31.5858 8L25.9289 13.6569C25.5384 14.0474 25.5384 14.6805 25.9289 15.0711C26.3195 15.4616 26.9526 15.4616 27.3431 15.0711L33.7071 8.70711ZM0 9H33V7H0V9Z" fill="white"/> </svg></a>',
	        
		});
		
		$('.project-gallery .gallery, .wp-block-gallery:not(.delay)').slick({
			infinite: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			dots: false,
			arrow: true,
			autoplay: true,
            autoplaySpeed: 2000,
            /*
	        fade: true,
	        cssEase: 'linear',
	        */
	        prevArrow: '<a class="slick-arrow slick-prev"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M0.292893 7.29289C-0.0976295 7.68341 -0.0976296 8.31658 0.292892 8.7071L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34314C8.46159 1.95262 8.46159 1.31945 8.07107 0.92893C7.68054 0.538406 7.04738 0.538405 6.65686 0.92893L0.292893 7.29289ZM34 7L1 7L1 9L34 9L34 7Z" fill="white"/> </svg></a>',
	        nextArrow: '<a class="slick-arrow slick-next"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M33.7071 8.70711C34.0976 8.31658 34.0976 7.68342 33.7071 7.29289L27.3431 0.928932C26.9526 0.538408 26.3195 0.538408 25.9289 0.928932C25.5384 1.31946 25.5384 1.95262 25.9289 2.34315L31.5858 8L25.9289 13.6569C25.5384 14.0474 25.5384 14.6805 25.9289 15.0711C26.3195 15.4616 26.9526 15.4616 27.3431 15.0711L33.7071 8.70711ZM0 9H33V7H0V9Z" fill="white"/> </svg></a>',
	        
		});
		
		$('.wp-block-gallery.delay').slick({
			infinite: true,
			slidesToShow: 1,
			slidesToScroll: 1,
			dots: false,
			arrow: true,
			autoplay: true,
            autoplaySpeed: 2300,
            /*
	        fade: true,
	        cssEase: 'linear',
	        */
	        prevArrow: '<a class="slick-arrow slick-prev"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M0.292893 7.29289C-0.0976295 7.68341 -0.0976296 8.31658 0.292892 8.7071L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34314C8.46159 1.95262 8.46159 1.31945 8.07107 0.92893C7.68054 0.538406 7.04738 0.538405 6.65686 0.92893L0.292893 7.29289ZM34 7L1 7L1 9L34 9L34 7Z" fill="white"/> </svg></a>',
	        nextArrow: '<a class="slick-arrow slick-next"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="16" viewBox="0 0 34 16" fill="none"> <path d="M33.7071 8.70711C34.0976 8.31658 34.0976 7.68342 33.7071 7.29289L27.3431 0.928932C26.9526 0.538408 26.3195 0.538408 25.9289 0.928932C25.5384 1.31946 25.5384 1.95262 25.9289 2.34315L31.5858 8L25.9289 13.6569C25.5384 14.0474 25.5384 14.6805 25.9289 15.0711C26.3195 15.4616 26.9526 15.4616 27.3431 15.0711L33.7071 8.70711ZM0 9H33V7H0V9Z" fill="white"/> </svg></a>',
	        
		});
		  
		  
		  
         
        setTimeout(function(){
            if ($(window).width() > 1024) {
                $(".wp-block-cover .wp-block-cover__inner-container, .wp-block-cover-image .wp-block-cover__inner-container").each(function(){
                    var thisHeight = $(this).height();
                    var windowHeight = $(window).height();
                    if (!$(this).find('.no-height-100')) {
                        if (thisHeight < windowHeight) $(this).addClass("should-be-full-height");
                    }
                });   
            } else {
                
                $("body:has( .featured-container) #airtec-logo").addClass('make-it-white');
                $("body:has( .featured-container) .mobile-menu-link").addClass('make-it-white');
                $("body:has( .featured-container) .wpml-ls-legacy-list-horizontal").addClass('make-it-white');
                if ($(".page-content.the-content:has( .contact-data)").length > 0) {
                    $(".mobile-menu").addClass('contact-mobile-menu');
                }
            }
            
            $(".mobile-menu").show();
       
        },300); 
            
            
        var backtoTopSVG = '<svg width="8" height="18" viewBox="0 0 8 18" fill="none"> <rect width="8" height="18" fill="#1E1E1E"/> <g clip-path="url(#clip0_0_1)"> <rect width="1920" height="4971" transform="translate(-1645 -4808)" fill="white"/> <path d="M4.35355 0.646446C4.15829 0.451185 3.84171 0.451185 3.64645 0.646446L0.464467 3.82843C0.269205 4.02369 0.269204 4.34027 0.464467 4.53553C0.659729 4.7308 0.976311 4.7308 1.17157 4.53553L4 1.70711L6.82843 4.53553C7.02369 4.7308 7.34027 4.7308 7.53553 4.53553C7.7308 4.34027 7.7308 4.02369 7.53553 3.82843L4.35355 0.646446ZM4.5 18L4.5 1L3.5 1L3.5 18L4.5 18Z" fill="black"/> </g> <defs> <clipPath id="clip0_0_1"> <rect width="1920" height="4971" fill="white" transform="translate(-1645 -4808)"/> </clipPath> </defs> </svg>';
       
       
        if ($(".main-footer .social-icons-list").length) $(".main-footer .social-icons-list").append('<li class="social-icon backtotop"><a href="#body-top">'+backtoTopSVG+'</a></li>');
		  
		
        
        $("select.wp-block-list.inner-links.hide-for-large").on('change',function () {
            
            var href = this.value.split('#')[1];
            href = 'is-'+href;
            $("#inner-output-links .wp-block-group").each(function(){
                if (href == 'is-all') {
                    $(this).addClass("visibility-on");
                    $(this).removeClass("visibility-off");
                } else if ($(this).attr('id') == href) {
                    $(this).addClass("visibility-on");
                    $(this).removeClass("visibility-off");
                } else {
                    $(this).addClass("visibility-off");
                    $(this).removeClass("visibility-on");
                }
            });
        });
		  
	});

} ( this, jQuery ));

// Avoid `console` errors in browsers that lack a console.
(function() {
	var method;
	var noop = function () {};
	var methods = [
		'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
		'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
		'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
		'timeStamp', 'trace', 'warn'
	];
	var length = methods.length;
	var console = (window.console = window.console || {});

	while (length--) {
		method = methods[length];

		// Only stub undefined methods.
		if (!console[method]) {
			console[method] = noop;
		}
	}
}());
